#include <bits/stdc++.h>

using namespace std;
const double EPS = 1e-8;

struct Point {
    double x, y;
    Point(double x = 0, double y = 0): x(x), y(y) {}
};

double dist2(const Point &a, const Point &b) {
    return (a.x - b.x)*(a.x - b.x) + (a.y - b.y)*(a.y - b.y);
}

Point midpoint(const Point &a, const Point &b) {
    return Point((a.x + b.x) / 2, (a.y + b.y) / 2);
}

Point circumcenter(const Point &a, const Point &b, const Point &c) {
    double d = 2 * (a.x*(b.y - c.y) + b.x*(c.y - a.y) + c.x*(a.y - b.y));
    double ux = ((a.x*a.x + a.y*a.y)*(b.y - c.y) +
                 (b.x*b.x + b.y*b.y)*(c.y - a.y) +
                 (c.x*c.x + c.y*c.y)*(a.y - b.y)) / d;
    double uy = ((a.x*a.x + a.y*a.y)*(c.x - b.x) +
                 (b.x*b.x + b.y*b.y)*(a.x - c.x) +
                 (c.x*c.x + c.y*c.y)*(b.x - a.x)) / d;
    return Point(ux, uy);
}

bool in_circle(const Point &center, double r2, const Point &p, bool strict = true) {
    double d = dist2(center, p);
    if (strict) return d < r2 - EPS;
    else return d <= r2 + EPS;
}
int main() {
  ios_base::sync_with_stdio(false);
  ios::sync_with_stdio(false);
  cin.tie(0);
  int t;
  cin >> t;
  while (t--) {
    int n;
    cin >> n;
    vector<Point> naski(3), ne_naski(n);
    for (int i = 0; i < 3; ++i){
      cin >> naski[i].x >> naski[i].y;
    }
    for (int i = 0; i < n; ++i){
      cin >> ne_naski[i].x >> ne_naski[i].y;
    }
    int max_cnt = 0;
    for (int i = 0; i < n; ++i) {
      Point c = ne_naski[i];
      double r2 = 0;
      bool ok = true;
      for (auto &s : naski) {
        if (in_circle(c, r2, s)) { ok = false; break; }
      }
      if (ok) {
        int cnt = 0;
        for (auto &t : ne_naski){
          if (in_circle(c, r2, t, false)) cnt++;
        }
        max_cnt = max(max_cnt, cnt);
      }
      for (int j = i+1; j < n; ++j) {
        Point c = midpoint(ne_naski[i], ne_naski[j]);
        double r2 = dist2(c, ne_naski[i]);
        bool ok = true;
        for (auto &s : naski){
          if (in_circle(c, r2, s)) { ok = false; break; }
        }
        if (ok) {
          int cnt = 0;
            for (auto &t : ne_naski){
              if (in_circle(c, r2, t, false)) cnt++;
            }
            max_cnt = max(max_cnt, cnt);
        }
        for (int k = j+1; k < n; ++k) {
          Point c = circumcenter(ne_naski[i], ne_naski[j], ne_naski[k]);
          double r2 = dist2(c, ne_naski[i]);
          bool ok = true;
          for (auto &s : naski)
            if (in_circle(c, r2, s)) { ok = false; break; }
          if (ok) {
            int cnt = 0;
            for (auto &t : ne_naski){
              if (in_circle(c, r2, t, false)) cnt++;
            }
            max_cnt = max(max_cnt, cnt);
          }
        }
      }
    }
    cout << max_cnt << endl;
  }
    return 0;
}