#include <iostream>
#include <vector>
#include <cmath>
using namespace std;

const double EPS = 1e-9;

struct Point {
    double x, y;
};

double dist2(Point a, Point b) {
    return (a.x - b.x)*(a.x - b.x) + (a.y - b.y)*(a.y - b.y);
}

// ???????? ?? ??????????? ?????? ????? ???? ??????? ???? ??? ?????
Point findCircleCenter(Point A, Point B, Point C) {
    double D = 2 * (A.x*(B.y - C.y) + B.x*(C.y - A.y) + C.x*(A.y - B.y));
    double Ux = ((A.x*A.x + A.y*A.y)*(B.y - C.y) + (B.x*B.x + B.y*B.y)*(C.y - A.y) + (C.x*C.x + C.y*C.y)*(A.y - B.y)) / D;
    double Uy = ((A.x*A.x + A.y*A.y)*(C.x - B.x) + (B.x*B.x + B.y*B.y)*(A.x - C.x) + (C.x*C.x + C.y*C.y)*(B.x - A.x)) / D;
    return {Ux, Uy};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int n;
        cin >> n;

        // ??? ????? ??????
        Point A, B, C;
        cin >> A.x >> A.y;
        cin >> B.x >> B.y;
        cin >> C.x >> C.y;

        // ?????? ????? ???? ??????? ???? A, B, C
        Point center = findCircleCenter(A, B, C);
        double radiusSquared = dist2(center, A);

        int count = 0;
        for (int i = 0; i < n; ++i) {
            Point leaf;
            cin >> leaf.x >> leaf.y;
            double d2 = dist2(center, leaf);
            if (d2 <= radiusSquared + EPS) {
                count++;
            }
        }

        cout << count << "\n";
    }

    return 0;
}