#include <iostream>
#include <cmath>
using namespace std;

const double EPS = 1e-9;



void centar(double ax, double ay, double bx, double by, double cx, double cy, double &ox, double &oy, double &r) {
    double D = 2 * (ax*(by - cy) + bx*(cy - ay) + cx*(ay - by));

    double A2 = ax*ax + ay*ay;
    double B2 = bx*bx + by*by;
    double C2 = cx*cx + cy*cy;

    ox = (A2*(by - cy) + B2*(cy - ay) + C2*(ay - by)) / D;
    oy = (A2*(cx - bx) + B2*(ax - cx) + C2*(bx - ax)) / D;

    r = sqrt((ox-ax)*(ox-ax) + (oy-ay)*(oy-ay));

}

bool uKrugu(double ox, double oy, double r, double px, double py) {
    double dx = ox - px, dy = oy - py;
    return dx * dx + dy * dy <= r * r+EPS;
}

int main() {
    
    ios::sync_with_stdio(false); cin.tie(0);
    int n, t;
    cin>>t;
    double ox, oy, r;
    while(t--){
        cin >> n;
        double x[n], y[n];
        double x1, y1, x2, y2, x3, y3;
        cin>>x1>>y1>>x2>>y2>>x3>>y3;
        for (int i = 0; i < n; i++) {
            cin >> x[i] >> y[i];
        }

        centar(x1, y1, x2, y2, x3, y3, ox, oy, r);
        int brojac = 0;
        for (int i = 0; i < n; i++) {
            if (uKrugu(ox, oy, r, x[i], y[i])) {
                brojac++;
                }
            }

        cout << brojac<<'\n';
        }
    
    return 0;
}