#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

const double EPS = 1e-9;

struct Point {
    double x, y;
};

double dist(Point a, Point b) {
    return hypot(a.x-b.x, a.y-b.y);
}

Point mid(Point a, Point b) {
    return {(a.x+b.x)/2, (a.y+b.y)/2};
}

Point circleCenter(Point A, Point B, Point C) {
    double D = 2*(A.x*(B.y-C.y) + B.x*(C.y-A.y) + C.x*(A.y-B.y));
    double Ux = ((A.x*A.x + A.y*A.y)*(B.y - C.y)+(B.x*B.x + B.y*B.y)*(C.y - A.y) + (C.x*C.x + C.y*C.y)*(A.y - B.y)) / D;
    double Uy = ((A.x*A.x + A.y*A.y)*(C.x - B.x)+(B.x*B.x + B.y*B.y)*(A.x - C.x) + (C.x*C.x + C.y*C.y)*(B.x - A.x)) / D;
    return {Ux, Uy};
}

bool inside(Point center, double radius, Point p) {
    return dist(center, p)<radius-EPS;
}

bool insideOrOn(Point center, double radius, Point p) {
    return dist(center, p)<=radius+EPS;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(0), std::cout.tie(0);

    int T;
    std::cin>>T;

    while (T--) {
        int n;
        std::cin>>n;

        std::vector<Point> srpski(3), tudji(n);
        for (int i=0; i<3; i++) std::cin>>srpski[i].x>>srpski[i].y;
        for (int i=0; i<n; i++) std::cin>>tudji[i].x>>tudji[i].y;

        int max_ukradenih=0;

        for (int i=0; i<n; i++) {
            Point o=tudji[i];
            double r=0;
            bool valid=true;
            for (auto& s:srpski)
                if (inside(o, r, s)) valid=false;
            if (!valid) continue;
            int count=0;
            for (auto& t:tudji)
                if (insideOrOn(o, r, t)) count++;
            max_ukradenih=std::max(max_ukradenih, count);
        }

        for (int i=0; i<n; i++) {
            for (int j=i+1; j<n; j++) {
                Point o=mid(tudji[i], tudji[j]);
                double r=dist(o, tudji[i]);
                bool valid=true;
                for (auto& s : srpski)
                    if (inside(o, r, s)) valid=false;
                if (!valid) continue;
                int count=0;
                for (auto& t:tudji)
                    if (insideOrOn(o, r, t)) count++;
                max_ukradenih=std::max(max_ukradenih, count);
            }
        }

        for (int i=0; i<n; i++) {
            for (int j=i+1; j<n; j++) {
                for (int k=j+1; k<n; k++) {
                    Point o=circleCenter(tudji[i], tudji[j], tudji[k]);
                    double r=dist(o, tudji[i]);
                    bool valid=true;
                    for (auto& s : srpski)
                        if (inside(o, r, s)) valid=false;
                    if (!valid) continue;
                    int count=0;
                    for (auto& t : tudji)
                        if (insideOrOn(o, r, t)) count++;
                    max_ukradenih=std::max(max_ukradenih, count);
                }
            }
        }

        std::cout<<max_ukradenih;
    }

    return 0;
}