#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

const double EPS = 1e-9;

struct Point {
double x, y;
};

double dist(Point a, Point b) {
return hypot(a.x - b.x, a.y - b.y);
}

// Centar kruga koji prolazi kroz 3 tacke
Point circleCenter(Point A, Point B, Point C) {
double D = 2 * (A.x*(B.y - C.y) + B.x*(C.y - A.y) + C.x*(A.y - B.y));
double Ux = ((A.x*A.x + A.y*A.y)*(B.y - C.y) + (B.x*B.x + B.y*B.y)*(C.y - A.y) + (C.x*C.x + C.y*C.y)*(A.y - B.y)) / D;
double Uy = ((A.x*A.x + A.y*A.y)*(C.x - B.x) + (B.x*B.x + B.y*B.y)*(A.x - C.x) + (C.x*C.x + C.y*C.y)*(B.x - A.x)) / D;
return {Ux, Uy};
}

int main() {
int T;
cin >> T;

while (T--) {
int n;
cin >> n;
vector<Point> srpski(n), tudji(n);

for (int i = 0; i < n; i++) cin >> srpski[i].x >> srpski[i].y;
for (int i = 0; i < n; i++) cin >> tudji[i].x >> tudji[i].y;

int max_ukradenih = 0;

// Svi trojci srpskih listova formiraju potencijalni krug
for (int i = 0; i < n; i++) {
for (int j = i+1; j < n; j++) {
for (int k = j+1; k < n; k++) {
Point A = srpski[i], B = srpski[j], C = srpski[k];
Point O = circleCenter(A, B, C);
double R = dist(O, A);

int ukradeni = 0;
for (auto& t : tudji) {
double d = dist(O, t);
if (d < R + EPS) ukradeni++;
}

max_ukradenih = max(max_ukradenih, ukradeni);
}
}
}

cout << max_ukradenih << endl;
}

return 0;
}