#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

struct Point {
    long long x, y;
};

double EPS=1e-9;

long long dist2(const Point& a, const Point& b) {
    long long dx=a.x-b.x;
    long long dy=a.y-b.y;
    return dx*dx+dy*dy;
}

Point mid(const Point& a, const Point& b) {
    return {(a.x+b.x), (a.y+b.y)};
}

bool inside(const Point& o, long long r2, const Point& p) {
    return dist2(o, p)<r2-1;
}

bool insideOrOn(const Point& o, long long r2, const Point& p) {
    return dist2(o, p)<=r2+1;
}

bool safe(const Point& o, long long r2, const std::vector<Point>& srpski) {
    for (const auto& s:srpski)
        if (inside(o, r2, s)) return false;
    return true;
}

bool getCircleCenter(const Point& A, const Point& B, const Point& C, Point& O, long long& R2) {
    long double a1=B.x-A.x, b1=B.y-A.y;
    long double a2=C.x-A.x, b2=C.y-A.y;
    long double d=2*(a1*b2-b1*a2);
    if (std::abs(d)<EPS) return false;

    long double c1=(B.x*B.x-A.x*A.x+B.y*B.y-A.y*A.y)/2.0;
    long double c2=(C.x*C.x-A.x*A.x+C.y*C.y-A.y*A.y)/2.0;
    long double cx=(c1*b2-c2*b1)/d;
    long double cy=(a1*c2-a2*c1)/d;

    O={(long long)(cx+A.x), (long long)(cy+A.y)};
    R2=dist2(O, A);
    return true;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(0), std::cout.tie(0);

    int T;
    std::cin>>T;

    while (T--) {
        int n;
        std::cin>>n;

        std::vector<Point> s(3), t(n);
        for (int i=0; i<3; i++) std::cin>>s[i].x>>s[i].y;
        for (int i=0; i<n; i++) std::cin>>t[i].x>>t[i].y;

        int res=0;

        for (int i=0; i<n; i++) {
            Point o=t[i];
            long long r2=0;
            if (!safe(o, r2, s)) continue;
            int cnt=0;
            for (const auto& p:t)
                if (insideOrOn(o, r2, p)) cnt++;
            res=std::max(res, cnt);
        }

        for (int i=0; i<n; i++)
            for (int j=i+1; j<n; j++) {
                Point o={(t[i].x+t[j].x)/2, (t[i].y+t[j].y)/2};
                long long r2=dist2(o, t[i]);
                if (!safe(o, r2, s)) continue;
                int cnt=0;
                for (const auto& p:t)
                    if (insideOrOn(o, r2, p)) cnt++;
                res=std::max(res, cnt);
            }

        for (int i=0; i<n; i++)
            for (int j=i+1; j<n; j++)
                for (int k=j+1; k<n; k++) {
                    Point o;
                    long long r2;
                    if (!getCircleCenter(t[i], t[j], t[k], o, r2)) continue;
                    if (!safe(o, r2, s)) continue;
                    int cnt=0;
                    for (const auto& p:t)
                        if (insideOrOn(o, r2, p)) cnt++;
                    res=std::max(res, cnt);
                }
        std::cout<<res;
    }
    return 0;
}