#include <iostream>
#include <vector>
#include <cmath>
#include <limits>

const double EPS=1e-9;
struct Tacka {
    double x, y;
    Tacka(int x=0, int y=0) : x(x), y(y) {}
};
double dist2(const Tacka& a, const Tacka& b) {
    return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}
bool kolinearne(Tacka a, Tacka b, Tacka c) {
    return fabs((b.x-a.x)*(c.y-a.y)-(b.y-a.y)*(c.x-a.x))<EPS;
}
bool napravi_krug(Tacka a, Tacka b, Tacka c, Tacka &centar, double &poluprecnik) {
    if (kolinearne(a, b, c)) return false;
    double A=b.x-a.x;
    double B=b.y-a.y;
    double C=c.x-a.x;
    double D=c.y-a.y;
    double E=A*(a.x+b.x)+B*(a.y+b.y);
    double F=C*(a.x+c.x)+D*(a.y+c.y);
    double G=2.0*(A*(c.y-b.y)-B*(c.x-b.x));
    if (fabs(G)<EPS) return false;
    centar.x=(D*E-B*F)/G;
    centar.y=(A*F-C*E)/G;
    poluprecnik=sqrt(dist2(centar, a));
    return true;
}
bool u_krugu(const Tacka& centar, double poluprecnik, const Tacka& t) {
    return dist2(centar, t)<=poluprecnik*poluprecnik+EPS;
}
int main() {
    int T;
    std::cin>>T;
    while (T--) {
        int n;
        std::cin>>n;
        std::vector<Tacka> srpski(n), tudji(n);
        for (int i=0; i<n; ++i) {
            int x, y;
            std::cin>>x>>y;
            srpski[i]=Tacka(x, y);
        }
        for (int i=0; i<n; ++i) {
            int x, y;
            std::cin>>x>>y;
            tudji[i]=Tacka(x, y);
        }
        int max_ukradenih=0;
        for (int i=0; i<n; ++i)
            for (int j=i+1; j<n; ++j)
                for (int k=j+1; k<n; ++k) {
                    Tacka centar;
                    double poluprecnik;
                    if (!napravi_krug(srpski[i], srpski[j], srpski[k], centar, poluprecnik))
                        continue;
                    int broj=0;
                    for (const auto& t:tudji)
                        if (u_krugu(centar, poluprecnik, t))
                            ++broj;

                    max_ukradenih=std::max(max_ukradenih, broj);
                }
        std::cout<<max_ukradenih;
    }
    return 0;
}