#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

const double EPS=1e-9;

struct Tacka {
    double x, y;
    Tacka(int x=0, int y=0) : x(x), y(y) {}
    bool operator<(const Tacka& p) const {
        return x<p.x || (x==p.x && y<p.y);
    }
};

double dist2(const Tacka& a, const Tacka& b) {
    return (a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}

bool napravi_krug(const Tacka& a, const Tacka& b, const Tacka& c, Tacka &centar, double &poluprecnik) {
    double D=2*(a.x*(b.y-c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y));
    double ux=((a.x*a.x + a.y * a.y) * (b.y - c.y) + (b.x * b.x + b.y * b.y) * (c.y - a.y) + (c.x * c.x + c.y * c.y) * (a.y - b.y)) / D;
    double uy=((a.x * a.x + a.y * a.y) * (c.x - b.x) + (b.x * b.x + b.y * b.y) * (a.x - c.x) + (c.x * c.x + c.y * c.y) * (b.x - a.x)) / D;
    centar = Tacka(ux, uy);
    poluprecnik = sqrt(dist2(centar, a));
    return true;
}

bool u_krugu(const Tacka& centar, double poluprecnik, const Tacka& p) {
    return dist2(centar, p) <= poluprecnik * poluprecnik + EPS;
}

std::vector<Tacka> konveksna_hull(std::vector<Tacka>& tacke) {
    std::sort(tacke.begin(), tacke.end());
    std::vector<Tacka> hull;
    for (int i = 0; i < tacke.size(); ++i) {
        while (hull.size()>=2 && (hull[hull.size()-2].x - hull[hull.size() - 1].x) * (tacke[i].y - hull[hull.size() - 1].y) - (hull[hull.size() - 2].y - hull[hull.size() - 1].y) * (tacke[i].x - hull[hull.size() - 1].x) <= 0)
            hull.pop_back();
        hull.push_back(tacke[i]);
    }
    int t = hull.size();
    for (int i = tacke.size()-2; i>=0; --i) {
        while (hull.size()>t && (hull[hull.size()-2].x-hull[hull.size()-1].x)*(tacke[i].y-hull[hull.size()-1].y)-(hull[hull.size()-2].y-hull[hull.size() - 1].y) * (tacke[i].x - hull[hull.size() - 1].x) <= 0)
            hull.pop_back();
        hull.push_back(tacke[i]);
    }
    hull.pop_back();
    return hull;
}

int main() {
    int T;
    std::cin>>T;
    while (T--) {
        int n;
        std::cin>>n;
        std::vector<Tacka> srpski(3);
        for (int i=0; i<3; ++i) {
            std::cin >> srpski[i].x >> srpski[i].y;
        }
        std::vector<Tacka> tudji(n);
        for (int i=0; i<n; ++i) {
            std::cin>>tudji[i].x>>tudji[i].y;
        }
        std::vector<Tacka> hull=konveksna_hull(tudji);
        int max_ukradenih=0;
        for (int i=0; i<hull.size(); ++i) {
            for (int j=i+1; j<hull.size(); ++j) {
                for (int k=j+1; k<hull.size(); ++k) {
                    Tacka centar;
                    double poluprecnik;
                    if (!napravi_krug(hull[i], hull[j], hull[k], centar, poluprecnik)) {
                        continue;
                    }
                    int count=0;
                    for (const auto& t : tudji) {
                        if (u_krugu(centar, poluprecnik, t)) {
                            ++count;
                        }
                    }
                    max_ukradenih=std::max(max_ukradenih, count);
                }
            }
        }
        std::cout<<max_ukradenih;
    }
    return 0;
}