#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

struct Tacka {
    int x, y;
    Tacka(int x = 0, int y = 0) : x(x), y(y) {}
};

long long dist_sq(const Tacka& a, const Tacka& b) {
    return (long long)(a.x - b.x) * (a.x - b.x) + (long long)(a.y - b.y) * (a.y - b.y);
}

bool unutar_ili_na_kruznici(const Tacka& centar, long long poluprecnik_sq, const Tacka& p) {
    return dist_sq(centar, p) <= poluprecnik_sq;
}

int main() {
    int T;
    std::cin >> T;

    while (T--) {
        int n;
        std::cin >> n;

        std::vector<Tacka> srpske(3);
        for (int i = 0; i < 3; ++i) {
            std::cin >> srpske[i].x >> srpske[i].y;
        }
        std::vector<Tacka> tudje(n);
        for (int i = 0; i < n; ++i) {
            std::cin >> tudje[i].x >> tudje[i].y;
        }
        int max_broj = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 3; ++j) {
                Tacka centar((srpske[i].x + srpske[j].x) / 2, (srpske[i].y + srpske[j].y) / 2);
                long long poluprecnik_sq = dist_sq(srpske[i], srpske[j]) / 4;
                int broj = 0;
                for (const Tacka& p : tudje) {
                    if (unutar_ili_na_kruznici(centar, poluprecnik_sq, p)) {
                        ++broj;
                    }
                }
                max_broj=std::max(max_broj, broj);
            }
        }
        std::cout<<max_broj;
    }

    return 0;
}