#include <iostream>
#include <vector>
#include <algorithm>
#include <complex>

#define xy std::complex<double>

bool krug(xy& p, xy& centar, double r) {
    return norm(p - centar) < r * r;
}

bool kruznica(xy& p, xy& centar, double r) {
    return norm(p - centar) <= r * r + 1e-8;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);

    int t;
    std::cin >> t;
    for (int it = 0; it < t; it++) {
        int n;
        std::cin >> n;

        std::vector<xy> srp(3);
        for (int i = 0; i < 3; i++) {
            int x, y;
            std::cin >> x >> y;
            srp[i] = xy(x, y);
        }

        std::vector<xy> str(n);
        for (int i = 0; i < n; i++) {
            int x, y;
            std::cin >> x >> y;
            str[i] = xy(x, y);
        }

        int max = 0;

        for (int i = 0; i < n; i++) {
            xy centar = str[i];
            double r = 0;
            bool check = true;
            for (xy& s : srp) {
                if (krug(s, centar, r)) {
                    check = false;
                    break;
                }
            }
            if (!check) continue;

            int iter = 0;
            for (xy& f : str) {
                if (kruznica(f, centar, r)) iter++;
            }
            if (max < iter) max = iter;
        }

        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                xy centar = (str[i] + str[j]) / 2.0;
                double r = abs(str[i] - centar);
                
                bool check = true;
                for (xy& s : srp) {
                    if (krug(s, centar, r)) {
                        check = false;
                        break;
                    }
                }
                if (!check) continue;

                int iter = 0;
                for (xy& f : str) {
                    if (kruznica(f, centar, r)) iter++;
                }
                if (max < iter) max = iter;
            }
        }

        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                for (int k = j + 1; k < n; k++) {
                    xy a = str[i], b = str[j], c = str[k];
                    
                    double x1 = a.real(), y1 = a.imag();
                    double x2 = b.real(), y2 = b.imag();
                    double x3 = c.real(), y3 = c.imag();
                
                    double a1 = x2 - x1, b1 = y2 - y1;
                    double c1 = (a1 * (x1 + x2) + b1 * (y1 + y2)) / 2;
                
                    double a2 = x3 - x1, b2 = y3 - y1;
                    double c2 = (a2 * (x1 + x3) + b2 * (y1 + y3)) / 2;
                
                    double det = a1 * b2 - a2 * b1;
                
                    double x = (c1 * b2 - c2 * b1) / det;
                    double y = (a1 * c2 - a2 * c1) / det;
                
                    xy centar = std::complex<double> {x, y};
                    double r = abs(a - centar);
                    
                    if (r < 0) continue;

                    bool check = true;
                    for (xy& s : srp) {
                        if (krug(s, centar, r)) {
                            check = false;
                            break;
                        }
                    }
                    if (!check) continue;

                    int iter = 0;
                    for (xy& f : str) {
                        if (kruznica(f, centar, r)) iter++;
                    }
                    if (max < iter) max = iter;
                }
            }
        }

        std::cout << max << std::endl;
    }
    return 0;
}