#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

const double EPSILON = 1e-9;

struct Tacka {
    double x, y;
};

double kvadrat_udaljenosti(const Tacka& a, const Tacka& b) {
    return (a.x - b.x)*(a.x - b.x) + (a.y - b.y)*(a.y - b.y);
}

bool je_unutra_striktno(const Tacka& tacka, const Tacka& centar, double r_kvadrat) {
    return kvadrat_udaljenosti(tacka, centar) < r_kvadrat - EPSILON;
}

bool je_unutra_ili_na_ivici(const Tacka& tacka, const Tacka& centar, double r_kvadrat) {
    return kvadrat_udaljenosti(tacka, centar) <= r_kvadrat + EPSILON;
}

bool napravi_krug(const Tacka& a, const Tacka& b, const Tacka& c, Tacka& centar, double& r_kvadrat) {
    double A1 = b.x - a.x;
    double B1 = b.y - a.y;
    double C1 = (A1*(a.x + b.x) + B1*(a.y + b.y)) / 2;

    double A2 = c.x - a.x;
    double B2 = c.y - a.y;
    double C2 = (A2*(a.x + c.x) + B2*(a.y + c.y)) / 2;

    double determinanta = A1*B2 - A2*B1;
    if (fabs(determinanta) < EPSILON) return false;

    centar.x = (C1*B2 - C2*B1) / determinanta;
    centar.y = (A1*C2 - A2*C1) / determinanta;
    r_kvadrat = kvadrat_udaljenosti(centar, a);
    return true;
}

int main() {
    int t;
    cin >> t;
    while (t--) {
        int broj_tudjih;
        cin >> broj_tudjih;
        vector<Tacka> srpski(3), tudji(broj_tudjih);
        for (int i = 0; i < 3; ++i)
            cin >> srpski[i].x >> srpski[i].y;
        for (int i = 0; i < broj_tudjih; ++i)
            cin >> tudji[i].x >> tudji[i].y;

        int maksimum = 0;

        // Krug kroz jednu tacku
        for (int i = 0; i < broj_tudjih; ++i) {
            Tacka centar = tudji[i];
            double r_kvadrat = 0;
            bool validan = true;
            for (Tacka& s : srpski)
                if (je_unutra_striktno(s, centar, r_kvadrat)) validan = false;
            if (!validan) continue;

            int broj = 0;
            for (Tacka& t : tudji)
                if (je_unutra_ili_na_ivici(t, centar, r_kvadrat)) broj++;
            maksimum = max(maksimum, broj);
        }

        // Krug kroz dve tacke
        for (int i = 0; i < broj_tudjih; ++i)
            for (int j = i+1; j < broj_tudjih; ++j) {
                Tacka centar = {(tudji[i].x + tudji[j].x)/2.0, (tudji[i].y + tudji[j].y)/2.0};
                double r_kvadrat = kvadrat_udaljenosti(centar, tudji[i]);
                bool validan = true;
                for (Tacka& s : srpski)
                    if (je_unutra_striktno(s, centar, r_kvadrat)) validan = false;
                if (!validan) continue;

                int broj = 0;
                for (Tacka& t : tudji)
                    if (je_unutra_ili_na_ivici(t, centar, r_kvadrat)) broj++;
                maksimum = max(maksimum, broj);
            }

        // Krug kroz tri tacke
        for (int i = 0; i < broj_tudjih; ++i)
            for (int j = i+1; j < broj_tudjih; ++j)
                for (int k = j+1; k < broj_tudjih; ++k) {
                    Tacka centar;
                    double r_kvadrat;
                    if (!napravi_krug(tudji[i], tudji[j], tudji[k], centar, r_kvadrat)) continue;
                    bool validan = true;
                    for (Tacka& s : srpski)
                        if (je_unutra_striktno(s, centar, r_kvadrat)) validan = false;
                    if (!validan) continue;

                    int broj = 0;
                    for (Tacka& t : tudji)
                        if (je_unutra_ili_na_ivici(t, centar, r_kvadrat)) broj++;
                    maksimum = max(maksimum, broj);
                }

        cout << maksimum << '\n';
    }
}