#include<bits/stdc++.h>
using namespace std;
using ll=long long;
using ld=long double;

const ll N=1e5+9;
struct tacka{
	ld x,y;
}A[N];

struct line{
	ld a,b,X;
	bool vert=0;
	ld eval(ld x,ld y){
		return a*x+b;
	};
};

const ld eps=1e-9;
ll n;

ld dst(tacka a,tacka b){
	return(a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y);
}

line getL(ld x1,ld y1,ld x2,ld y2){
	line ret={0,0,0,0};
	if(x1==x2){
		ret.vert=1;
		ret.X=x1;
	}
	else ret.a=(y2-y1)/(x2-x1);
	ret.b=(y1-ret.a*x1);
	return ret;
}

line nwL(line L,ld x,ld y){
	line ret={0,0,0,0};
	if(L.vert)ret.a=0;
	else if(L.a==0){
		ret.vert=1;
		ret.X=x;
	}
	else ret.a=-1.0/L.a;
	ret.b=y-ret.a*x;
	return ret;
}

tacka presek(line L1,line L2){
	tacka ret={0,0};
	if(L1.vert&&L2.vert)return{-1e12,0};
	if(L1.vert){
		ret.x=L1.X;
		ret.y=L2.a*ret.x+L2.b;
	}else if(L2.vert){
		ret.x=L2.X;
		ret.y=L1.a*ret.x+L1.b;
	}else{
		if(L1.a==L2.a)return{-1e12,0};
		ret.x=(L2.b-L1.b)/(L1.a-L2.a);
		ret.y=L1.a*ret.x+L1.b;
	}
	return ret;
}

ll get(ll i,ll j,ll k,bool AA){
	tacka a=A[i],b=A[j],c=A[k];
	ld x1=a.x,y1=a.y,x2=b.x,y2=b.y,x3=c.x,y3=c.y;
	ld mABx=(x1+x2)/2,mABy=(y1+y2)/2,mBCx=(x2+x3)/2,mBCy=(y2+y3)/2;
	line L1=getL(x1,y1,x2,y2);
	line L2=getL(x2,y2,x3,y3);
	L1=nwL(L1,mABx,mABy);
	L2=nwL(L2,mBCx,mBCy);
	tacka C=presek(L1,L2);
	assert(C.x>-1e11);
	ld D=dst(a,C);
	ll cc=1,mx=(AA?n+3:min(305ll,n+3));
	for(int x=1;x<=mx;++x){
		if(x==i||x==j||x==k||dst(A[x],C)-D>eps)continue;
		if(x<=3)return 0;
		++cc;
	}
	return cc-AA;
}

void solve(){
	cin>>n;
	for(int i=1;i<=n+3;++i)
		cin>>A[i].x>>A[i].y;

	ll ans=get(1,2,3,1);
	for(int i=1;i<=3;++i){
		for(int j=i+1;j<=3;++j){
			for(int k=4;k<=min((ll)300+5,n+3);++k)
				ans=max(ans,get(i,j,k,0));
		}
	}

	cout<<ans<<'\n';
}

signed main(){
    ios::sync_with_stdio(0);
    cin.tie(0);
    ll T;cin>>T;
    while(T--)solve();
}