import sys
from math import hypot
from random import shuffle
sys.setrecursionlimit(1<<25)

def krug(a,b,c):
    A=((b[0]-a[0])*(c[0]-a[0])+(b[1]-a[1])*(c[1]-a[1]))
    B=((a[0]-b[0])*(c[0]-b[0])+(a[1]-b[1])*(c[1]-b[1]))
    C=((a[0]-c[0])*(b[0]-c[0])+(a[1]-c[1])*(b[1]-c[1]))
    suma=A+B+C
    xa=(A*a[0]+B*b[0]+C*c[0])/suma
    ya=(A*a[1]+B*b[1]+C*c[1])/suma
    r=hypot(a[0]-xa,a[1]-ya)
    return xa,ya,r

def udalj(p1,p2):
    return hypot(p1[0]-p2[0],p1[1]-p2[1])

def unutra(centar,r, tacka):
    return udalj(centar,tacka)<r-1e-8

def naivno(srpski, tudji):
    najvise=0
    for i in range(len(tudji)):
        for j in range(i+1,len(tudji)):
            for k in range(j+1,len(tudji)):
                try:
                    x,y,r=krug(tudji[i],tudji[j],tudji[k])
                except: continue
                if any(unutra((x,y),r,s) for s in srpski): continue
                broj=sum(udalj((x,y),t)<=r+1e-8 for t in tudji)
                najvise=max(najvise,broj)
    for i in range(len(tudji)):
        for j in range(i+1,len(tudji)):
            x=(tudji[i][0]+tudji[j][0])/2
            y=(tudji[i][1]+tudji[j][1])/2
            r=udalj(tudji[i],tudji[j])/2
            if any(unutra((x,y),r,s) for s in srpski): continue
            broj=sum(udalj((x,y),t)<=r+1e-8 for t in tudji)
            najvise=max(najvise,broj)
    for i in range(len(tudji)):
        x,y=tudji[i]
        r=0
        if any(unutra((x,y),r,s) for s in srpski): continue
        broj=sum(udalj((x,y),t)<=r+1e-8 for t in tudji)
        najvise=max(najvise,broj)
    return najvise

t=int(sys.stdin.readline())
for _ in range(t):
    n=int(sys.stdin.readline())
    srpski=[tuple(map(int,sys.stdin.readline().split()))for _ in range(3)]
    tudji=[tuple(map(int,sys.stdin.readline().split()))for _ in range(n)]
    print(naivno(srpski,tudji))