#include <complex>
#include <iostream>
#include <numeric>
#include <random>
#include <vector>
using namespace std;
using P = complex<double>;
const double maxeps = 1e-8;
double sq(double x) { return x * x; }
double d2(const P &a, const P &b) { return norm(a - b); }
double d(const P &a, const P &b) { return abs(a - b); }
struct krug {
    P c;
    double r;
    bool sad(const P &p) const {
        return d2(c, p) < r * r - maxeps;
    }
    bool sadOr(const P &p) const {
        return d2(c, p) <= r * r + maxeps;
    }
};
krug od(const P &a, const P &b) {
    P center = (a + b) / 2.0;
    double r = d(a, b) / 2.0;
    return {center, r};
}
bool krug3(const P &a, const P &b, const P &c, krug &out) {
    double d = 2 * (real(a)*(imag(b)-imag(c)) + real(b)*(imag(c)-imag(a)) + real(c)*(imag(a)-imag(b)));
    if (abs(d) < maxeps) return false;
    double x = (norm(a)*(imag(b)-imag(c)) + norm(b)*(imag(c)-imag(a)) + norm(c)*(imag(a)-imag(b))) / d;
    double y = (norm(a)*(real(c)-real(b)) + norm(b)*(real(a)-real(c)) + norm(c)*(real(b)-real(a))) / d;
    P center(x, y);
    double r = abs(center - a);
    out = {center, r};
    return true;
}
int r(const vector<P> &srb, const vector<P> &str) {
    int n = str.size();
    int b = 0;
    for (int i = 0; i < n; ++i)
    for (int j = i+1; j < n; ++j) {
        krug c = od(str[i], str[j]);
        bool v = true;
        for (const auto &s : srb)
            if (c.sad(s)) {
                v = false;
                break;
            }
        if (!v) continue;
        int cn = 0;
        for (const auto &f : str)
            if (c.sadOr(f))
                ++cn;
        b = max(b, cn);
    }
    vector<int> idx(n);
    iota(idx.begin(), idx.end(), 0);
    mt19937 rand(42);
    uniform_int_distribution<int> dist(0, n - 1);
    for (int t = 0; t < 5000; ++t) {
        int i = dist(rand), j = dist(rand), k = dist(rand);
        if (i == j || j == k || i == k) continue;
        krug c;
        if (!krug3(str[i], str[j], str[k], c)) continue;
        bool v = true;
        for (const auto &s : srb)
            if (c.sad(s)) {
                v = false;
                break;
            }
        if (!v) continue;
        int cn = 0;
        for (const auto &f : str)
            if (c.sadOr(f))
                ++cn;
        b = max(b, cn);
    }
    return b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t;
    cin >> t;
    while (t--) {
        int n;
        cin >> n;
        vector<P> srb(3);
        for (int i = 0; i < 3; ++i) {
            int x, y; cin >> x >> y;
            srb[i] = P(x, y);
        }
        vector<P> str(n);
        for (int i = 0; i < n; ++i) {
            int x, y; cin >> x >> y;
            str[i] = P(x, y);
        }
        cout << r(srb, str) << "\n";
    }
}