#include <complex>
#include <iostream>
#include <random>
#include <vector>
using namespace std;
using P = complex<double>;
const double maxeps = 1e-8;
double sq(double x) { return x * x; }
double d2(const P &a, const P &b) { return norm(a - b); }
double d(const P &a, const P &b) { return abs(a - b); }
struct krug {
    P c;
    double r;
    bool sad(const P &p) const {
        return d2(c, p) < r * r - maxeps;
    }
    bool sadOr(const P &p) const {
        return d2(c, p) <= r * r + maxeps;
    }
};
krug od(const P &a, const P &b) {
    P c = (a + b) / 2.0;
    double r = d(a, b) / 2.0;
    return {c, r};
}
bool krug3(const P &a, const P &b, const P &c, krug &out) {
    double d = 2 * (real(a)*(imag(b)-imag(c)) + real(b)*(imag(c)-imag(a)) + real(c)*(imag(a)-imag(b)));
    if (abs(d) < maxeps) return false;
    double x = (norm(a)*(imag(b)-imag(c)) + norm(b)*(imag(c)-imag(a)) + norm(c)*(imag(a)-imag(b))) / d;
    double y = (norm(a)*(real(c)-real(b)) + norm(b)*(real(a)-real(c)) + norm(c)*(real(b)-real(a))) / d;
    P c(x, y);
    double r = abs(c - a);
    out = {c, r};
    return true;
}
int r(const vector<P> &srb, const vector<P> &str) {
    int n = str.size();
    int b = 0;
    if (n <= 2000) {
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                krug c = od(str[i], str[j]);
                bool v = true;
                for (const auto &s : srb)
                    if (c.sad(s)) { v = false; break; }
                if (!v) continue;
                int cn = 0;
                for (int t = 0; t < n; ++t) {
                    if (c.sadOr(str[t])) ++cn;
                    if (cn + (n - 1 - t) <= b) break;
                }
                b = max(b, cn);
            }
        }
    }
    mt19937 rand(42);
    uniform_int_distribution<int> dist(0, n - 1);
    int sp = (n <= 2000 ? 0 : 500);
    for (int t = 0; t < sp; ++t) {
        int i = dist(rand), j = dist(rand);
        if (i == j) { --t; continue; }
        krug c = od(str[i], str[j]);
        bool v = true;
        for (const auto &s : srb)
            if (c.sad(s)) { v = false; break; }
        if (!v) continue;
        int cn = 0;
        for (int u = 0; u < n; ++u) {
            if (c.sadOr(str[u])) ++cn;
            if (cn + (n - 1 - u) <= b) break;
        }
        b = max(b, cn);
    }
    int st = (n <= 2000 ? 5000 : 500);
    for (int t = 0; t < st; ++t) {
        int i = dist(rand), j = dist(rand), k = dist(rand);
        if (i == j || j == k || i == k) { --t; continue; }
        krug c;
        if (!krug3(str[i], str[j], str[k], c)) { --t; continue; }
        bool v = true;
        for (const auto &s : srb)
            if (c.sad(s)) { v = false; break; }
        if (!v) continue;
        int cn = 0;
        for (int u = 0; u < n; ++u) {
            if (c.sadOr(str[u])) ++cn;
            if (cn + (n - 1 - u) <= b) break;
        }
        b = max(b, cn);
    }
    return b;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t;
    cin >> t;
    while (t--) {
        int n;
        cin >> n;
        vector<P> srb(3);
        for (int i = 0; i < 3; ++i) {
            int x, y; cin >> x >> y;
            srb[i] = P(x, y);
        }
        vector<P> str(n);
        for (int i = 0; i < n; ++i) {
            int x, y; cin >> x >> y;
            str[i] = P(x, y);
        }
        cout << r(srb, str) << "\n";
    }
    return 0;
}