#include <complex>
#include <iostream>
#include <random>
#include <vector>
using namespace std;
using P = complex<double>;
const double maxeps = 1e-8;
double d2(const P &a, const P &b){ return norm(a - b); }
double d1(const P &a, const P &b){ return abs(a - b); }
struct C {
    P o; double r;
    bool inS(const P &p) const { return d2(o,p) < r*r - maxeps; }
    bool inE(const P &p) const { return d2(o,p) <= r*r + maxeps; }
};

C m2(const P &a, const P &b){
    P o = (a+b)*0.5;
    return {o, d1(a,b)*0.5};
}

bool m3(const P &a, const P &b, const P &c, C &o){
    double d = 2*(real(a)*(imag(b)-imag(c))
               + real(b)*(imag(c)-imag(a))
               + real(c)*(imag(a)-imag(b)));
    if(fabs(d)<maxeps) return false;
    double A=norm(a), B=norm(b), Cc=norm(c);
    double ux = ( A*(imag(b)-imag(c))
                + B*(imag(c)-imag(a))
                + Cc*(imag(a)-imag(b)) )/d;
    double uy = ( A*( real(c)-real(b))
                + B*( real(a)-real(c))
                + Cc*( real(b)-real(a)) )/d;
    P o0(ux,uy);
    o = {o0, d1(o0,a)};
    return true;
}

int go(const vector<P>& b1, const vector<P>& r1){
    int nR=r1.size(), nB=b1.size(), r=0;
    vector<P> V=r1;
    V.insert(V.end(), b1.begin(), b1.end());
    int m=V.size();
    auto chk=[&](const C& c){
        for(auto &b:b1) if(c.inS(b)) return;
        int cnt=0;
        for(auto &r:r1) if(c.inE(r)) ++cnt;
        r=max(r,cnt);
    };

    if(m<=2000){
        for(int i=0;i<m;i++) for(int j=i+1;j<m;j++)
            chk(m2(V[i],V[j]));
        C c;
        for(int i=0;i<m;i++) for(int j=i+1;j<m;j++) for(int k=j+1;k<m;k++)
            if(m3(V[i],V[j],V[k],c)) chk(c);
        return r;
    }

    mt19937_64 rand(1);
    uniform_int_distribution<int> dI(0,m-1);
    for(int it=0;it<2000;it++){
        int i=dI(rand), j=dI(rand);
        if(i==j){--it; continue;}
        chk(m2(V[i],V[j]));
    }
    C c;
    for(int it=0;it<5000;it++){
        int i=dI(rand), j=dI(rand), k=dI(rand);
        if(i==j || j==k || i==k){--it; continue;}
        if(m3(V[i],V[j],V[k],c)) chk(c);
    }
    return r;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t; cin>>t;
    while(t--){
        int n; cin>>n;
        vector<P> b(3), r(n);
        for(int i=0;i<3;i++){
            long long x,y; cin>>x>>y;
            b[i]=P(x,y);
        }
        for(int i=0;i<n;i++){
            long long x,y; cin>>x>>y;
            r[i]=P(x,y);
        }
        cout<<go(b,r)<<"\n";
    }
}