#include <iostream>
#include <vector>
using namespace std;
const double maxeps = 1e-9;
struct P {
    double x, y;
    P(double x=0, double y=0): x(x), y(y) {}
    double d2(const P &p) const {
        return (x - p.x)*(x - p.x) + (y - p.y)*(y - p.y);
    }
};
struct krug {
    P c;
    double r2;
    krug(P c=P(), double r2=0): c(c), r2(r2) {}

    bool sad(const P &p, bool strict = false) const {
        double d = c.d2(p);
        return strict ? d < r2 - maxeps : d <= r2 + maxeps;
    }
};
krug od2(const P &a, const P &b) {
    P center((a.x + b.x)/2, (a.y + b.y)/2);
    double r2 = center.d2(a);
    return {center, r2};
}
krug od3(const P &a, const P &b, const P &c) {
    double a1 = b.x - a.x, B = b.y - a.y;
    double b1 = c.x - a.x, D = c.y - a.y;
    double c1 = a1*(a.x + b.x) + B*(a.y + b.y);
    double d1 = b1*(a.x + c.x) + D*(a.y + c.y);
    double e1 = 2*(a1*(c.y - b.y) - B*(c.x - b.x));
    if (abs(e1) < maxeps) return {{0,0}, -1};
    P o((D*c1 - B*d1)/e1, (a1*d1 - b1*c1)/e1);
    double r2 = o.d2(a);
    return {o, r2};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t; cin >> t;
    while (t--) {
        int n; cin >> n;
        vector<P> srb(3);
        for (int i = 0; i < 3; ++i)
            cin >> srb[i].x >> srb[i].y;
        vector<P> str(n);
        for (int i = 0; i < n; ++i)
            cin >> str[i].x >> str[i].y;

        int r = 0;
        for (int i = 0; i < n; ++i)
            for (int j = i+1; j < n; ++j) {
                krug c = od2(str[i], str[j]);
                bool ok = true;
                for (const auto &s : srb)
                    if (c.sad(s, true)) {
                        ok = false;
                        break;
                    }
                if (!ok) continue;
                int b = 0;
                for (const auto &p : str)
                    if (c.sad(p))
                        b++;
                r = max(r, b);
            }

        for (int i = 0; i < n; ++i)
            for (int j = i+1; j < n; ++j)
                for (int k = j+1; k < n; ++k) {
                    krug c = od3(str[i], str[j], str[k]);
                    if (c.r2 < 0) continue;
                    bool ok = true;
                    for (const auto &s : srb)
                        if (c.sad(s, true)) {
                            ok = false;
                            break;
                        }
                    if (!ok) continue;
                    int b = 0;
                    for (const auto &p : str)
                        if (c.sad(p))
                            b++;
                    r = max(r, b);
                }

        cout << r;
    }
}