#include <iostream>
#include <vector>
using namespace std;
typedef long long ll;
typedef long double ld;
const ld maxeps = 1e-9;
struct P {
    ld x, y;
    P(ld x = 0, ld y = 0): x(x), y(y) {}
};

ld d2(const P& a, const P& b) {
    return (a.x - b.x)*(a.x - b.x) + (a.y - b.y)*(a.y - b.y);
}

bool u(const P& c, ld r2, const P& p, bool s) {
    ld d = d2(c, p);
    return s ? d < r2 - maxeps : d <= r2 + maxeps;
}

pair<P, ld> krugR(const P& a, const P& b) {
    P c((a.x + b.x) / 2, (a.y + b.y) / 2);
    ld r2 = d2(c, a);
    return {c, r2};
}

pair<P, ld> krug3(const P& a, const P& b, const P& c) {
    ld p1 = b.x - a.x, B = b.y - a.y;
    ld p2 = c.x - a.x, D = c.y - a.y;
    ld p3 = p1 * (a.x + b.x) + B * (a.y + b.y);
    ld p4 = p2 * (a.x + c.x) + D * (a.y + c.y);
    ld p5 = 2 * (p1 * (c.y - b.y) - B * (c.x - b.x));
    if (abs(p5) < maxeps) return {{0, 0}, -1};
    P cent((D * p3 - B * p4) / p5, (p1 * p4 - p2 * p3) / p5);
    ld r2 = d2(cent, a);
    return {cent, r2};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t; cin >> t;
    while (t--) {
        int n;
        cin >> n;
        vector<P> srb(3), str(n);
        for (int i = 0; i < 3; i++) cin >> srb[i].x >> srb[i].y;
        for (int i = 0; i < n; i++) cin >> str[i].x >> str[i].y;
        int r = 0;

        for (int i = 0; i < n; i++) for (int j = i+1; j < n; j++) {
            auto [c, r2] = krugR(str[i], str[j]);
            bool ok = true;
            for (const auto& s : srb)
                if (u(c, r2, s, true)) {
                    ok = false;
                    break;
                }
            if (!ok) continue;
            int br = 0;
            for (const auto& p : str)
                if (u(c, r2, p, false))
                    br++;
            r = max(r, br);
        }

        for (int i = 0; i < n; i++) for (int j = i+1; j < n; j++) for (int k = j+1; k < n; k++) {
            auto [c, r2] = krug3(str[i], str[j], str[k]);
            if (r2 < 0) continue;
            bool ok = true;
            for (const auto& s : srb)
                if (u(c, r2, s, true)) {
                    ok = false;
                    break;
                }
            if (!ok) continue;
            int br = 0;
            for (const auto& p : str)
                if (u(c, r2, p, false))
                    br++;
            r = max(r, br);
        }

        cout << r;
    }
}