#include <bits/stdc++.h>
using namespace std;
using ld = long double;
struct P { ld x,y; };
inline ld sqr(ld x){ return x*x; }

P cc(const P &A, const P &B, const P &C){
    ld p1 = B.x - A.x, b = B.y - A.y;
    ld p2 = C.x - A.x, d = C.y - A.y;
    ld p3 = p1*(A.x+B.x) + b*(A.y+B.y);
    ld p4 = p2*(A.x+C.x) + d*(A.y+C.y);
    ld p5 = 2*(p1*(C.y-B.y) - b*(C.x-B.x));
    if(fabsl(p5) < 1e-18L)
        return P{1e30L,1e30L};
    return P{ ( d*p3 - b*p4)/p5, (p1*p4 - p2*p3)/p5 };
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t;
    cin >> t;
    while(t--){
        int n; cin >> n;
        vector<P> srb(3), str(n);
        for(int i=0;i<3;i++) cin >> srb[i].x >> srb[i].y;
        for(int i=0;i<n;i++) cin >> str[i].x >> str[i].y;
        int res = 0;
        auto tr = [&](const P &C, ld R2){
            if(C.x > 1e20L) return;
            const ld eps = 1e-12L;
            for(auto &B: srb){
                ld d2 = sqr(B.x - C.x) + sqr(B.y - C.y);
                if(d2 < R2 - eps)
                    return;
            }
            int br = 0;
            for(auto &R: str){
                ld d2 = sqr(R.x - C.x) + sqr(R.y - C.y);
                if(d2 <= R2 + eps) br++;
            }
            res = max(res, br);
        };
            P c = cc(srb[0],srb[1],srb[2]);
            ld r2 = sqr(c.x - srb[0].x) + sqr(c.y - srb[0].y);
            tr(c, r2);
        for(int i=0;i<3;i++) for(int j=i+1;j<3;j++){
            for(auto &R: str){
                P c = cc(srb[i], srb[j], R);
                ld r2 = sqr(c.x - R.x) + sqr(c.y - R.y);
                tr(c, r2);
            }
        }

        cout << res;
    }
}