#include <algorithm>
#include <complex>
#include <iostream>
#include <vector>
using namespace std;
using ll = long long;
const double EPS=1e-12, INF=1e18;
int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t; cin>>t;
    while(t--){
        int n; cin>>n;
        vector<pair<double,double>> b(3), p(n);
        for(int i=0;i<3;i++)cin>>b[i].first>>b[i].second;
        for(int i=0;i<n;i++)cin>>p[i].first>>p[i].second;
        int res=0;
        for(int i=0;i<3;i++)for(int j=i+1;j<3;j++){
            int k=3-i-j;
            double ax=b[i].first, ay=b[i].second;
            double bx=b[j].first, by=b[j].second;
            double dx=bx-ax, dy=by-ay;
            double d2=dx*dx+dy*dy, d=sqrt(d2);
            double mx=(ax+bx)/2, my=(ay+by)/2;
            double vx=-dy/d, vy=dx/d;
            vector<double> vp, vm;
            int ne=0, ba=0, po=0;
            for(auto &q:p){
                double wx=q.first-mx, wy=q.second-my;
                double a=wx*vx+wy*vy;
                double b2=wx*wx+wy*wy - d2/4;
                if (a>EPS){
                    vp.push_back(b2/(2*a));
                    po++;
                } else if(a<-EPS){
                    vm.push_back(b2/(2*a));
                    ne++;
                } else if(b2<=0) ba++;
            }
            double wx=b[k].first-mx, wy=b[k].second-my;
            double ak=wx*vx+wy*vy;
            double bk=wx*wx+wy*wy - d2/4;
            bool dl=0;
            int md=0; double tb=0;
            if(fabs(ak)<=EPS){
                if(bk<0) continue;
                dl=1;
            }else if(ak>0){
                md=1; tb=bk/(2*ak);
            }else{
                md=2; tb=-bk/(2*ak);
            }
            auto odg=[&](vector<double>&p1,vector<double>&m1,int ic,int bc,double bnd){
                sort(p1.begin(),p1.end());
                sort(m1.begin(),m1.end());
                int i1=0,j1=0,sz1=p1.size(),sz2=m1.size();
                int c=ic+bc, mxv=c;
                while(i1<sz1||j1<sz2){
                    double t=INF;
                    if(i1<sz1) t=min(t,p1[i1]);
                    if(j1<sz2) t=min(t,m1[j1]);
                    if(t>bnd+EPS) break;
                    while(i1<sz1 && fabs(p1[i1]-t)<=EPS){c++;i1++;}
                    mxv=max(mxv,c);
                    while(j1<sz2 && fabs(m1[j1]-t)<=EPS){c--;j1++;}
                }
                return mxv;
            };
            int naj=0;
            if(dl||md==1) naj = max(naj, odg(vp,vm,ne,ba, dl?INF:tb));
            if(dl||md==2){
                for(auto &x:vp)x=-x;
                for(auto &x:vm)x=-x;
                naj = max(naj, odg(vm,vp,po,ba, dl?INF:-tb));
            }
            res=max(res,naj);
        }
        {
            double ax=b[0].first, ay=b[0].second;
            double bx=b[1].first, by=b[1].second;
            double cx=b[2].first, cy=b[2].second;
            double d=2*(ax*(by-cy)+bx*(cy-ay)+cx*(ay-by));
            if(fabs(d)>EPS){
                double ux=((ax*ax+ay*ay)*(by-cy)+(bx*bx+by*by)*(cy-ay)+(cx*cx+cy*cy)*(ay-by))/d;
                double uy=((ax*ax+ay*ay)*(cx-bx)+(bx*bx+by*by)*(ax-cx)+(cx*cx+cy*cy)*(bx-ax))/d;
                double r2=(ux-ax)*(ux-ax)+(uy-ay)*(uy-ay);
                int c=0;
                for(auto &q:p){
                    double dx=q.first-ux, dy=q.second-uy;
                    if(dx*dx+dy*dy <= r2+EPS) c++;
                }
                res=max(res,c);
            }
        }
        cout<<res;
    }
}