import sys
import math
from itertools import combinations

def read():
    return list(map(int, sys.stdin.readline().split()))

def d2(p1, p2):
    return (p1[0] - p2[0])**2 + (p1[1] - p2[1])**2

def krug2(p1, p2):
    cx = (p1[0] + p2[0]) / 2
    cy = (p1[1] + p2[1]) / 2
    r2 = d2(p1, p2) / 4
    return (cx, cy, r2)

def krug3(p1, p2, p3):
    p1 = p2[0] - p1[0]
    p2 = p2[1] - p1[1]
    p3 = p3[0] - p1[0]
    p4 = p3[1] - p1[1]
    p5 = p1*(p1[0] + p2[0]) + p2*(p1[1] + p2[1])
    p6 = p3*(p1[0] + p3[0]) + p4*(p1[1] + p3[1])
    p7 = 2*(p1*(p3[1] - p2[1]) - p2*(p3[0] - p2[0]))
    if p7 == 0:
        return None
    cx = (p4*p5 - p2*p6) / p7
    cy = (p1*p6 - p3*p5) / p7
    r2 = (cx - p1[0])**2 + (cy - p1[1])**2
    return (cx, cy, r2)

def uK(px, py, cx, cy, r2):
    return (px - cx)**2 + (py - cy)**2 <= r2 + 1e-8

def uKs(px, py, cx, cy, r2):
    return (px - cx)**2 + (py - cy)**2 < r2 - 1e-8

t = int(sys.stdin.readline())
for _ in range(t):
    n = int(sys.stdin.readline())
    srp = [tuple(read()) for _ in range(3)]
    str = [tuple(read()) for _ in range(n)]
    res = 0

    p = srp + str
    for co in combinations(p, 2):
        c = krug2(*co)
        if c is None:
            continue
        cx, cy, r2 = c
        if any(uKs(b[0], b[1], cx, cy, r2) for b in srp):
            continue
        count = sum(uK(r[0], r[1], cx, cy, r2) for r in str)
        res = max(res, count)

    for co in combinations(p, 3):
        c = krug3(*co)
        if c is None:
            continue
        cx, cy, r2 = c
        if any(uKs(b[0], b[1], cx, cy, r2) for b in srp):
            continue
        count = sum(uK(r[0], r[1], cx, cy, r2) for r in str)
        res = max(res, count)

    print(res)