import sys
import math
from itertools import combinations

def read():
    return list(map(int, sys.stdin.readline().split()))

def u(krug, po):
    cx, cy, r2 = krug
    dx = po[0] - cx
    dy = po[1] - cy
    return dx * dx + dy * dy < r2 - 1e-8

def una(krug, po):
    cx, cy, r2 = krug
    dx = po[0] - cx
    dy = po[1] - cy
    return dx * dx + dy * dy <= r2 + 1e-8

def od(p1, p2, p3):
    t1 = p2[0] - p1[0]
    t2 = p2[1] - p1[1]
    t3 = p3[0] - p1[0]
    t4 = p3[1] - p1[1]
    t5 = t1 * (p1[0] + p2[0]) + t2 * (p1[1] + p2[1])
    t6 = t3 * (p1[0] + p3[0]) + t4 * (p1[1] + p3[1])
    t7 = 2 * (t1 * (p3[1] - p2[1]) - t2 * (p3[0] - p2[0]))
    if t7 == 0:
        return None
    cx = (t4 * t5 - t2 * t6) / t7
    cy = (t1 * t6 - t3 * t5) / t7
    r2 = (cx - p1[0]) ** 2 + (cy - p1[1]) ** 2
    return (cx, cy, r2)

def main():
    t = int(sys.stdin.readline())
    for _ in range(t):
        n = int(sys.stdin.readline())
        srb = [tuple(read()) for _ in range(3)]
        str = [tuple(read()) for _ in range(n)]
        maks = 0

        for p1, p2, p3 in combinations(str, 3):
            krug = od(p1, p2, p3)
            if krug is None:
                continue
            if any(u(krug, s) for s in srb):
                continue
            br = sum(una(krug, f) for f in str)
            maks = max(maks, br)

        for p1, p2 in combinations(str, 2):
            for s in srb:
                krug = od(p1, p2, s)
                if krug is None:
                    continue
                if any(u(krug, s2) for s2 in srb if s2 != s):
                    continue
                br = sum(una(krug, f) for f in str)
                maks = max(maks, br)

        for p in str:
            for s1, s2 in combinations(srb, 2):
                krug = od(p, s1, s2)
                if krug is None:
                    continue
                if any(u(krug, s3) for s3 in srb if s3 != s1 and s3 != s2):
                    continue
                br = sum(una(krug, f) for f in str)
                maks = max(maks, br)

        print(maks)

if __name__ == "__main__":
    main()