#include <bits/stdc++.h>
 
using namespace std;
 
struct DynamicSegmentTree{
    using B = long long; // boundary type
    using T = pair<long long, int>; // value type
    const T nullval = {0, 0};
 
    static T merge(const T &a, const T &b){
        return {a.first + b.first, a.second + b.second};
    }
 
    // =========================
 
    struct Node{
        T val;
        int lft, rght;
    };
 
    vector<Node> tree;
    int root{};
 
    const B leftBound{}, rightBound{};
 
    DynamicSegmentTree() = default;
 
    explicit DynamicSegmentTree(const B leftBound_, const B rightBound_, const int reserveSize = 0) : root(newNode()), leftBound(leftBound_), rightBound(rightBound_){
        tree.reserve(reserveSize);
    }
 
    int newNode(){
        tree.push_back(Node{nullval, -1, -1});
 
        return tree.size() - 1;
    }
 
    void update_(const int v, const B l, const B r, const B pos, const T val){
        if(l == r) tree[v].val = merge(tree[v].val, val);
        else{
            const B m = l + (r - l) / 2;
 
            if(pos <= m){
                update_(tree[v].lft == -1 ? tree[v].lft = newNode() : tree[v].lft, l, m, pos, val);
                tree[v].val = merge(tree[tree[v].lft].val, tree[v].rght == -1 ? nullval : tree[tree[v].rght].val);
            }
            else{
                update_(tree[v].rght == -1 ? tree[v].rght = newNode() : tree[v].rght, m + 1, r, pos, val);
                tree[v].val = merge(tree[v].lft == -1 ? nullval : tree[tree[v].lft].val, tree[tree[v].rght].val);
            }
        }
    }
 
    template<typename U, typename = enable_if_t<is_convertible_v<U, T>>>
    void update(const B pos, const U val){
        update_(root, leftBound, rightBound, pos, (T)val);
    }
 
    long long query_(const int v, const B l, const B r, const int k) const{
        if(v == -1 || k == 0) return 0;
        if(tree[v].val.second <= k) return tree[v].val.first;
        if(l == r) return l * min(tree[v].val.second, k);
 
        const B m = l + (r - l) / 2;
 
        if(tree[v].rght == -1) return query_(tree[v].lft, l, m, k);
 
        if(tree[tree[v].rght].val.second >= k) return query_(tree[v].rght, m + 1, r, k);
        else return tree[tree[v].rght].val.first + query_(tree[v].lft, l, m, k - tree[tree[v].rght].val.second);
    }
 
    long long query(const int k) const{
        return query_(root, leftBound, rightBound, k);
    }
};
 
void solve(){
    int n, q;
 
    cin >> n >> q;
 
    vector<int> arr(n + 1);
    vector<long long> sums(n + 1, 0);
 
    for(int i = 1; i <= n; i++){
        cin >> arr[i];
        sums[arr[i]] += arr[i];
    }
 
    DynamicSegmentTree sgt(1, 1ll * n * n);
 
    for(int i = 1; i <= n; i++) if(sums[i]) sgt.update(sums[i], pair{sums[i], 1});
 
    long long totalsum = accumulate(arr.begin(), arr.end(), 0ll);
 
    while(q--){
        int qt;
 
        cin >> qt;
 
        if(qt == 1){
            int k;
            cin >> k;
 
            cout << totalsum - sgt.query(n - k) << '\n';
        }
        else{
            int i, x;
            cin >> i >> x;
 
            sgt.update(sums[arr[i]], pair{-sums[arr[i]], -1});
            sums[arr[i]] -= arr[i];
            totalsum -= arr[i];
            if(sums[arr[i]]) sgt.update(sums[arr[i]], pair{sums[arr[i]], 1});
 
            if(sums[x]) sgt.update(sums[x], pair{-sums[x], -1});
 
            arr[i] = x;
 
            sums[arr[i]] += arr[i];
            totalsum += arr[i];
            sgt.update(sums[arr[i]], pair{sums[arr[i]], 1});
        }
    }
}
 
int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
 
    int t=1;
    //cin >> t;
    while(t--) solve();
}
