
У шпилу се налази $N$ карата. Карта на врху шпила има индекс $1$, а карта испод карте $i$ има индекс $i+1$. На карти $i$ је написан природан број $a_i$. 

<br>

Играмо следећу игру. Прво изаберемо природни број $k$ и узмемо првих $k$ карата у руку. Након тога понављамо следећи поступак докле год је остало карата у шпилу:


- Повучемо прву карту са врха шпила и ставимо је у нашу руку. 
- Изаберемо неку карту из наше руке (може, а не мора бити карта коју смо управо извукли). Нека је на њој написан број $x$. Изаберемо колико код хоћемо карата из наше руке са бројем $x$ на њима (али барем једну) и одиграмо те карте (више нам нису у руци, али се **не враћају** у шпил).

<br>

Наш циљ је да након што смо одиграли све потезе сума карата у нашој руци буде најмања могућа. 

<br>

Дат Вам је низ $a$ и $Q$ упита над њим. Имамо два типа упита:


- ``1 x`` - Наћи најмању могућу вредност суме карата у нашој руци ако играмо игру над тренутним низом и претпоставимо да је $k = x$. 

- ``2 x y`` - Променимо вредност карте $x$ у $y$. Односно $a_x := y$. 

<br>

## Опис улаза


Прва линија улаза садржи бројеве $N$ и $Q$ - број карата у шпилу и број упита.


Друга линија улаза садржи $N$ бројева $a_1, a_2, ..., a_n$ - елементе низа $a$.


Следећих $Q$ линија описује сваки од упита. Први број је број $t$, тип упита. Ако је $t=1$ онда се након броја $t$ налази број $x$. Ако је $t=2$, онда се након броја $t$ налазе бројеви $x$ и $y$.

<br>

## Опис излаза


За сваки упит типа $t=1$ исписати један број — одговор на тај упит.

<br>

## Пример 1


### Улаз

~~~
6 6

1 1 2 2 3 3
1 1
1 2
1 3
1 4
1 5
1 6
~~~


### Излаз

~~~
0
0
0
2
6
12
~~~


### Објашњење

У првом упиту ћемо на почетку у руци имати карту са бројем $1$. Након тога, вучемо карту са бројем $1$, па у руци имамо карте са бројевима $1$ и $1$. Затим бирамо $x=1$ и одигравамо обе карте са бројем $1$, након чега је наша рука празна. У следећих $4$ потеза бирамо број $x$ да буде једнак броју на карти коју смо управо извукли и одиграмо ту карту. На крају свих потеза наша рука је празна, па је сума свих карата у нашој руци $0$. 

У другом упиту на почетку у руци имамо карте са бројевима $1$ и $1$, а вучемо карте са бројевима $2$, $2$, $3$ и $3$ редом. Играмо слично као у првом и трећем упиту.

У трећем упиту на почетку у руци имамо карте са бројевима $1$, $1$ и $2$. Играмо на следећи начин:

- У првом потезу повлачимо карту са бројем $2$. Бирамо $x=1$ и одиграмо обе карте са бројем $1$. У руци имамо две карте са бројем $2$. 
- У другом потезу повлачимо карту са бројем $3$. Бирамо $x=2$ и одиграмо обе карте са бројем $2$. У руци имамо једну карту са бројем $3$.
- У трећем потезу повлачимо карту са бројем $3$. Бирамо $x=3$ и одиграмо обе карте са бројем $3$. Немамо ни једну карту у руци, па је одговор $0$.

У четвртом упиту ћемо на почетку у руци имати карте са бројевима $1$, $1$, $2$ и $2$. Играмо на следећи начин:
- У првом потезу вучемо карту са бројем $3$. Бирамо $x=2$ и одиграмо обе карте са бројем $2$. У нашој руци су карте са бројевима $1$, $1$ и $3$.
- У другом потезу вучемо карту са бројем $3$. Бирамо $x=3$ и одиграмо обе карте са бројем $3$. У нашој руци су карте са бројевима $1$, $1$. Сума бројева на картама је $1 + 1 = 2$. Може се доказати да мања сума на крају игре није могућа.

У петом упиту ћемо на почетку у руци имати карте са бројевима $1$, $1$, $2$, $2$ и $3$. У првом и једином потезу вучемо карту са бројем $3$. Затим бирамо $x=3$ и одигравамо обе карте са бројем $3$. У руци су нам карте са бројевима $1$, $1$, $2$, $2$, а њихова сума је $1+1+2+2 = 6$.

У шестом упиту ћемо на почетку у руци имати карте са бројевима $1$, $1$, $2$, $2$, $3$ и $3$. С обзиром са су нам све карте већ у руци, нећемо одиграти ниједан потез, па је сума карата у руци $1+1+2+2+3+3 = 12$. 

<br>

## Пример 2


### Улаз

~~~
10 4
1 2 3 2 4 2 1 2 3 3
1 6
2 9 5
2 6 5
1 7
~~~


### Излаз

~~~
0
6
~~~


### Објашњење

У првом упиту је низ $a  = [1, 2, 3, 2, 4, 2, 1, 2, 3, 3]$. У руци су нам карте са бројевима $1$, $2$, $3$, $2$, $4$, $2$, а вучемо редом карте са бројевима $1$, $2$, $3$, $3$. Постоји начин играња потеза такав да нам на крају рука буде празна.

У другом упиту се мења елемент низа $a$ на позицији $9$ у $5$, па је низ $a  = [1, 2, 3, 2, 4, 2, 1, 2,$ **5** $, 3]$.

 У трећам упиту се мења елемент низа $a$ на позицији $6$ у $5$, па је низ $a  = [1, 2, 3, 2, 4,$ **5** $, 1, 2, 5, 3]$.

У четвртом упиту су нам у руци карте са бројевима $1$, $2$, $3$, $2$, $4$, $5$, $1$, а вучемо редом карте са бројевима $2$, $5$, $3$. Може се доказати да ће, при оптималној игри, збир карата у руци бити $6$.

## Пример 3

<br>

### Улаз

~~~
11 3
11 10 9 8 7 6 1 1 1 2 2
1 6
2 7 3
1 5
~~~


### Излаз

~~~
13
9
~~~

<br>

## Ограничења

- $1 \leq N, Q \leq 2\cdot10^5$
- $1 \leq a_i \leq N$, за свако $1 \le i \le N$ 
- $t_i \in \{1, 2\}$, за сваки упит $1\le i \le Q$
- $1 \le x_i \le N$, за све упите типа $t_i=1$ за $1 \le i \le Q$
- $1 \le x_i, y_i \le N$, за све упите типа $t_i = 2$ за $1 \le i \le Q$
- Постоји барем један упит за који је $t_i = 1$

<br>

Тест примери су подељени у седам група:

- у тест примерима вредним $10$ поена важи: $Q = 1$, $x_1 = 1$. 
- у тест примерима вредним $10$ поена важи: $N, Q \le 5$;
- у тест примерима вредним $30$ поена важи: $Q = 1$; 
- у тест примерима вредним $10$ поена важи: $t_i = 1$ , за свако $1 \le i \le Q$;
- у тест примерима вредним $10$ поена важи: За све упите $i$ типа $t_i = 1$ важи $x_i \ge N -100$;
- у тест примерима вредним $10$ поена важи: За све упите $i$ типа $t_i = 1$ важи $x_i \le 100$;
- у тест примерима вредним $20$ поена: нема додатних ограничења.

<br>
