Дато је $n$ тачака у јединичном квадрату $[0,1]\times [0,1]$. Скуп тих $n$ тачака зваћемо $P$. Нека је $MST$ најмање разапињуће стабло$^2$ над комплетним графом над овим тачкама, где тежину грана између тачака $i$ и $j$ са координатама $(x_i,y_i)$ и $(x_j,y_j)$ рачунамо као Менхетн дистанцу, тј. $|x_i-x_j|+|y_i-y_j|$. Гарантује се да је $MST$ над овим графом јединствен.
<br>
Великом Перици се свидело како изгледа овај $MST$, и пошто се ближи Нова година и потребно му је новогодишњe стабло, жели да има исто такво стабло код куће. Код куће нема пуно простора па би хтео да стабло у његовој кући има највише $\frac{18}{\epsilon^2}$ тачака. Пошто њему није битна величина, већ напротив само облик стабла жели да $MST$ и стабло у његовој кући буду $\epsilon$-слични.

Ваш задатак је да изаберете подскуп тачака $Q \subseteq P$, и неко разапињуће стабло$^1$ $Т$ (не нужно минимално) над комплетним графом над $Q$:

1.  Q има највише $\frac{18}{\epsilon^2}$ тачака
    
2.  $MST$ и $Т$ су $\epsilon$-слични.
    
За два разапињућа стабла кажемо да су $\epsilon$-слични, ако за сваку тачку на првом стаблу постоји бар једна тачка на другом стаблу на Менхетн дистанци највише $\epsilon$ и за сваку тачку на другом стаблу постоји бар једна тачка на првом стаблу на Менхетн дистанци највише $\epsilon$. Под тачке на неком стаблу мисли се на све чворове и сваку тачку на свакој грани из стабла. Грана између чворова $i$ и $j$ је дуж која спаја $(x_i,y_i)$ и $(x_j,y_j)$.<br> 
$^1$ Разапињуће стабло над графом са $m$ чворова са скупом грана $E$ је скуп $F \subseteq E$ величине $m-1$ тако да је за сваки од $m$ чворова изабрана бар једна грана која садржи тај чвор. <br>
$^2$ Минимално разапињуће стабло за граф је оно разапињуће стабло за тај граф које има минимални збир тежина свих грана у њему.

## Опис улаза  
У првој линији стандардног улаза су дати цео број $n$ (број тачака), и број $\epsilon$ на 10 децимала. У наредних $n$ линија стандардног улаза налазе се по два броја на 10 децимала - $x_i,y_i$, координате тачке $i$ . 
## Опис излаза  
У првој линији стандардног излаза испишите $|Q|$ - величину изабраног подскупа. У следећем реду испишите $k$ бројева који представљају индексе тачака које су у том скупу. У следећих $k-1$ линија исписати по два броја који представљају гране које су у изабраном разапињућем стаблу $T$. 
## Пример 1
### Улаз
 ``` 
5 0.3000000000000
0.4000000000000 0.5000000000000
0.5000000000000 0.2500000000000
0.3000000000000 1.0000000000000
1.0000000000000 0.6000000000000
0.9000000000000 0.4000000000000
```   
### Излаз  
 ```
4
1 2 3 5
1 2
2 5
1 3 
 ```  
### Објашњење примера
У овом примеру $MST$ тачака чине гране $(4,5), (1,2), (2,5), (1,3)$. За тачку $4$ ван стабла $T$ тачка $5$ је на дистанци највише $\epsilon$. За тачке на грани $(4,5)$ која је у $MST$ је тачка $5$ на дистанци највише $\epsilon$. За остале тачке (чворове, и тачке на гранама). свака је сама себи на дистанци $0$, тј. највише $\epsilon$. У овом примеру је могуће да Перица узме цео $MST$, тј. свих 5 тачака. Овај пример је илустративан, у тест примерима који се бодују није могуће добити $\epsilon = 0.3$ у улазу.
## Ограничења  
- $1 \leq n \leq 20000$  
- $0 \leq x_i,y_i \leq 1$
- $10^{-3} \leq \epsilon \leq 1$

Тест примери су подељени у $5$ дисјунктних група:
 - У тестовима вредним $10$ поена: важи $n \leq 20, \epsilon = 0.01$.
 - У тестовима вредним $20$ поена: важи $n \leq 1000$ и $\epsilon = 0.2$.  
 - У тестовима вредним $20$ поена: важи $\epsilon = 10^{-3}$  
 - У тестовима вредним $50$ поена: $\epsilon = 0.05$ или $\epsilon = 0.1$. 