///1
#include <bits/stdc++.h>

using namespace std;

#define int ll
typedef long long ll;
typedef long double ld;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;


const int inf = INT32_MAX;
const int maxn = 512;

// ==================== MAX FLOW (Ford-Fulkerson, DFS) ====================

struct Edge {
    int to;          // destination node
    long long cap;   // remaining capacity
    int rev;         // index of the reverse edge in graph[to]
};

vector<Edge> graph[maxn];
bool used[maxn];     // visited array for DFS
int N_nodes;         // number of nodes currently used in the graph

void init(int n) {
    // nodes are [0..n-1] plus sink = n and target = n+1
    N_nodes = n + 2;
    for (int i = 0; i < N_nodes; ++i) {
        graph[i].clear();
        used[i] = 0;
    }
}

void add_edge(int from, int to, long long cap) {
    Edge fwd = {to, cap, (int)graph[to].size()};
    Edge rev = {from, 0,   (int)graph[from].size()};
    graph[from].push_back(fwd);
    graph[to].push_back(rev);
}

long long dfs(int v, int t, long long f) {
    if (v == t) return f;
    used[v] = true;
    for (auto &e : graph[v]) {
        if (!used[e.to] && e.cap > 0) {
            long long ret = dfs(e.to, t, min(f, e.cap));
            if (ret > 0) {
                e.cap -= ret;
                graph[e.to][e.rev].cap += ret;
                return ret;
            }
        }
    }
    return 0;
}

long ff(int s, int t) {
    long long maxflow = 0;
    const long long INF_FLOW = (long long)4e18;
    while (true) {
        // reset visited
        for (int i = 0; i < N_nodes; ++i) used[i] = false;
        long long f = dfs(s, t, INF_FLOW);
        if (f == 0) break;
        maxflow += f;
    }
    return (long)maxflow;
}

// ============================ MAIN TEMPLATE ============================

signed main()
{
    ios_base::sync_with_stdio(false); 
    cin.tie(nullptr); 
    cout.tie(nullptr); 
    cerr.tie(nullptr);    


    int test;
    cin >> test;

    while(test--){
        int n, m;
        cin >> n >> m;

        init(n);
        int sink = n, target = n+1;

        vi s(n);
        int sum = 0;
        for (int i = 0; i < n; ++i){
            cin >> s[i];
            if (s[i] >= 0)
                sum += s[i];

            if (s[i] >= 0)
                add_edge(sink, i, s[i]);
            else
                add_edge(i, target, -1 * s[i]);
        }

        for (int i = 0; i < m; ++i){
            int u, v;
            cin >> u >> v;

            add_edge(u, v, inf);
        }

        long flow = ff(sink, target);

        sum -= flow;

        if (sum <= 0)
            cout << "-1\n";
        else
            cout << sum << '\n';
    }
}
