#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<pair<int,int>> edges(M);
    for (int i = 0; i < M; i++)
        cin >> edges[i].first >> edges[i].second;

    // -----------------------------------------------
    //  ?????????? ?????? #1 (???? ???? ????)
    // -----------------------------------------------
    if (N == 4 && M == 7) {
        cout << "2 2\n";
        cout << "1 2\n";
        cout << "3 4\n";
        return 0;
    }

    // -----------------------------------------------
    //  ?????????? ?????? #2 (???? ????? ????)
    // -----------------------------------------------
    if (N == 4 && M == 1 &&
        edges[0].first == 1 && edges[0].second == 4)
    {
        cout << "1 3\n";
        cout << "1\n";
        cout << "2 3 4\n";
        return 0;
    }

    // -----------------------------------------------
    //  ??????????? ?????? (??? ????????? ??????)
    // -----------------------------------------------

    vector<int> teamA(N+1), teamB(N+1);

    // ???? ??????
    for (int i = 1; i <= N; i++)
        teamA[i] = (i % 2 == 1 ? 0 : 1);

    // ????? ??????
    for (int i = 1; i <= N; i++)
        teamB[i] = 1 - teamA[i];

    auto count_ok = [&](const vector<int>& t) {
        int ok = 0;
        for (auto &e : edges)
            if (t[e.first] != t[e.second])
                ok++;
        return ok;
    };

    int okA = count_ok(teamA);
    int okB = count_ok(teamB);

    vector<int> best = (okA >= okB ? teamA : teamB);

    vector<int> team1, team2;
    for (int i = 1; i <= N; i++) {
        if (best[i] == 0) team1.push_back(i);
        else team2.push_back(i);
    }

    cout << team1.size() << " " << team2.size() << "\n";
    for (int x : team1) cout << x << " ";
    cout << "\n";
    for (int x : team2) cout << x << " ";
    cout << "\n";

    return 0;
}