#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<vector<int>> adj(N+1);
    vector<pair<int,int>> edges;
    edges.reserve(M);

    for (int i = 0; i < M; i++) {
        int A, B;
        cin >> A >> B;
        edges.emplace_back(A, B);
        adj[A].push_back(B);
        adj[B].push_back(A);
    }

    // inicialno svi u tim 0
    vector<int> team(N+1, 0);

    auto count_satisfied = [&](int v, int newTeam) {
        int oldTeam = team[v];
        int delta = 0;

        for (int u : adj[v]) {
            // ??? ?? ???? ????? ?????????? ? ????? ????, -1
            if (team[u] != oldTeam) delta--;
            // ??? ????? ??????? ???? ??????????, +1
            if (team[u] != newTeam) delta++;
        }
        return delta;
    };

    bool improved = true;
    while (improved) {
        improved = false;
        for (int v = 1; v <= N; v++) {
            int delta = count_satisfied(v, 1 - team[v]);
            if (delta > 0) {
                team[v] ^= 1; 
                improved = true;
            }
        }
    }

    // ????????? ??????? ??????
    vector<int> t0, t1;
    for (int i = 1; i <= N; i++) {
        if (team[i] == 0) t0.push_back(i);
        else t1.push_back(i);
    }

    cout << t0.size() << " " << t1.size() << "\n";
    for (int x : t0) cout << x << " ";
    cout << "\n";
    for (int x : t1) cout << x << " ";
    cout << "\n";

    return 0;
}