#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<vector<int>> a(N+1);
    vector<pair<int,int>> ivice;
    ivice.reserve(M);

    for (int i = 0; i < M; i++) {
        int A, B;
        cin >> A >> B;
        ivice.emplace_back(A, B);
        a[A].push_back(B);
        a[B].push_back(A);
    }

    vector<int> tim(N+1, 0);

    auto count_satisfied = [&](int v, int newTeam) {
        int oldTeam = tim[v];
        int delta = 0;

        for (int u : a[v]) {
            if (tim[u] != oldTeam)
                 delta--;
            if (tim[u] != newTeam) 
                delta++;
        }
        return delta;
    };

    bool improved = true;
    while (improved) {
        improved = false;
        for (int v = 1; v <= N; v++) {
            int delta = count_satisfied(v, 1 - tim[v]);
            if (delta > 0) {
                tim[v] ^= 1; 
                improved = true;
            }
        }
    }

    vector<int> t0, t1;
    for (int i = 1; i <= N; i++) {
        if (tim[i] == 0) t0.push_back(i);
        else t1.push_back(i);
    }

    cout << t0.size() << " " << t1.size() << "\n";
    for (int x : t0) 
        cout << x << " ";
    cout << "\n";
    for (int x : t1) 
        cout << x << " ";
    cout << "\n";

    return 0;
}