using System;
using System.Collections.Generic;

class Program
{
    static List<int>[] g, gr;
    static bool[] used;
    static int[] comp;
    static long[] compSum;
    static bool[] hasOut;
    static Stack<int> st;
    static int[] K;

    static void DFS1(int v)
    {
        used[v] = true;
        foreach (int to in g[v])
            if (!used[to])
                DFS1(to);
        st.Push(v);
    }

    static void DFS2(int v, int c)
    {
        comp[v] = c;
        compSum[c] += K[v];
        foreach (int to in gr[v])
            if (comp[to] == -1)
                DFS2(to, c);
    }

    static void Main()
    {
        int T = int.Parse(Console.ReadLine());

        while (T-- > 0)
        {
            var nm = Console.ReadLine().Split();
            int N = int.Parse(nm[0]);
            int M = int.Parse(nm[1]);

            K = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

            g = new List<int>[N];
            gr = new List<int>[N];
            for (int i = 0; i < N; i++)
            {
                g[i] = new List<int>();
                gr[i] = new List<int>();
            }

            for (int i = 0; i < M; i++)
            {
                var ab = Console.ReadLine().Split();
                int a = int.Parse(ab[0]);
                int b = int.Parse(ab[1]);
                g[a].Add(b);
                gr[b].Add(a);
            }

            used = new bool[N];
            st = new Stack<int>();

            for (int i = 0; i < N; i++)
                if (!used[i])
                    DFS1(i);

            comp = new int[N];
            Array.Fill(comp, -1);

            compSum = new long[N];
            int cnt = 0;

            while (st.Count > 0)
            {
                int v = st.Pop();
                if (comp[v] == -1)
                {
                    DFS2(v, cnt);
                    cnt++;
                }
            }

            hasOut = new bool[cnt];

            for (int v = 0; v < N; v++)
                foreach (int to in g[v])
                    if (comp[v] != comp[to])
                        hasOut[comp[v]] = true;

            long ans = 0;
            for (int i = 0; i < cnt; i++)
                if (!hasOut[i] && compSum[i] > 0)
                    ans += compSum[i];

            Console.WriteLine(ans > 0 ? ans : -1);
        }
    }
}