#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <limits>
#include <vector>
#include <utility>

using namespace std;

vector<int> k;
vector<pair<int, int>> tunnels;
vector<vector<int>> max_weights;
unordered_map<int, unordered_set<int>> adjacency_set;

void bellman_ford(int src) {
    int n = max_weights.size();
    int m = tunnels.size();
    for (int i = 0; i<n; i++) {
        max_weights[src][i] = INT16_MIN;
    }
    max_weights[src][src] = k[src];

    for (int i = 0; i<n-1; i++) {
        for (auto tunnel : tunnels) {
            if (tunnel.second == src) return;
            int new_weight = max_weights[src][tunnel.first] + k[tunnel.second];
            if (new_weight > max_weights[src][tunnel.second]) {
                max_weights[src][tunnel.second] = new_weight;
            }
        }
    }
    
}

pair<int, int> max(vector<vector<int>> v) {
    int max = v[0][0];
    int imax = 0, jmax = 0;
    for (int i = 0; i<v.size(); i++) {
        for (int j = 0; j<v.size(); j++) {
            if (v[i][j] > max) {
                max = v[i][j];
                imax = i;
                jmax = j;
            }
        }
    }
    return pair<int, int>(imax, jmax);
}

int solve() {
    int n = max_weights.size();

    for (int i = 0; i<n; i++) {
        bellman_ford(i);
    }
    pair<int, int> res = max(max_weights);

    return (max_weights[res.first][res.second] > 0 && adjacency_set.find(res.second) == adjacency_set.end()) ? 
    max_weights[res.first][res.second] : -1;

}



void clear_adjacency_set() {
    for (auto set : adjacency_set) {
        set.second.clear();
    }
    adjacency_set.clear();
    adjacency_set.reserve(0);
}

int main() {
    int t, n, m, a, b;
    cin>>t;

    for (int i = 0; i<t; i++) {
        cin>>n>>m;
        tunnels.resize(m);
        max_weights.resize(n);
        k.resize(n); 

        for (int i = 0; i<n; i++) {
            cin>>k[i];
            max_weights[i].resize(n);
        }

        for (int i = 0; i<m; i++) {
            cin>>a>>b;
            tunnels[i] = pair<int, int>(a, b);
            adjacency_set[a].insert(b);
        }

        
        cout<<solve()<<"\n";
        clear_adjacency_set();
        // for (int i = 0; i<n; i++) {
        //     for (int j = 0; j<n; j++) {
        //         cout<<max_weights[i][j]<<" ";
        //     }
        //     cout<<"\n";
        // }
    }
    

}