from collections import deque

def add_edge(G, fr, to, cap):
    G[fr].append([to, len(G[to]), cap])
    G[to].append([fr, len(G[fr])-1, 0])

def bfs(G, s, t, level):
    for i in range(len(level)):
        level[i] = -1
    level[s] = 0
    q = deque([s])
    while q:
        u = q.popleft()
        for v, rev, c in G[u]:
            if c > 0 and level[v] < 0:
                level[v] = level[u] + 1
                q.append(v)
    return level[t] >= 0

def dfs(G, u, t, f, level, iter):
    if u == t:
        return f
    while iter[u] < len(G[u]):
        v, rev, c = G[u][iter[u]]
        if c > 0 and level[v] == level[u] + 1:
            d = dfs(G, v, t, min(f, c), level, iter)
            if d > 0:
                G[u][iter[u]][2] -= d
                G[v][rev][2] += d
                return d
        iter[u] += 1
    return 0

def max_flow(G, s, t):
    flow = 0
    level = [0] * len(G)
    INF = 10**18
    while bfs(G, s, t, level):
        iter = [0] * len(G)
        while True:
            f = dfs(G, s, t, INF, level, iter)
            if f == 0:
                break
            flow += f
    return flow

t = int(input())
for _ in range(t):
    n, m = map(int, input().split())
    k = list(map(int, input().split()))
    edges = [[] for _ in range(n)]
    redges = [[] for _ in range(n)]
    for _ in range(m):
        a,b = map(int,input().split())
        edges[a].append(b)
        redges[b].append(a)

    used = [False]*n
    order = []
    def dfs1(u):
        used[u] = True
        for v in edges[u]:
            if not used[v]:
                dfs1(v)
        order.append(u)
    for i in range(n):
        if not used[i]:
            dfs1(i)

    comp = [-1]*n
    cid = 0
    for u in reversed(order):
        if comp[u] == -1:
            stack = [u]
            comp[u] = cid
            while stack:
                x = stack.pop()
                for v in redges[x]:
                    if comp[v] == -1:
                        comp[v] = cid
                        stack.append(v)
            cid += 1

    W = [0]*cid
    for i in range(n):
        W[comp[i]] += k[i]

    dag = set()
    for a in range(n):
        for b in edges[a]:
            ca, cb = comp[a], comp[b]
            if ca != cb:
                dag.add((ca, cb))

    S = cid
    T = cid + 1
    G = [[] for _ in range(cid+2)]
    pos_sum = 0
    for i in range(cid):
        if W[i] > 0:
            add_edge(G, S, i, W[i])
            pos_sum += W[i]
        elif W[i] < 0:
            add_edge(G, i, T, -W[i])
    INF = 10**18
    for u,v in dag:
        add_edge(G, u, v, INF)

    mincut = max_flow(G, S, T)
    ans = pos_sum - mincut
    print(ans if ans > 0 else -1)