#include <bits/stdc++.h>

using namespace std;

#define fi first
#define se second

class Graf
{
    int N;
    list<int> *l;

    public:
        Graf(int n)
        {
            N=n;
            l=new list<int>[N];
        }

    void addEdge(int i,int j,bool dir)
    {
        l[i].push_back(j);
        if(dir==false)l[j].push_back(i);
    }

    void print()
    {
        for(int i=0; i<N; i++)
        {
            for(auto node:l[i])
            {
                cout << node << " " ;
            }
            cout << endl;
        }
    }

    void dfsH(int a,bool *visited,int t1,vector<int> *v1,vector<int> *v2)
    {
        if(visited[a]==true)return;

        visited[a]=true;
        if(t1==1)(*v1).push_back(a);
        else if(t1==-1)(*v2).push_back(a);

        for(auto br:l[a])
        {
            if(!visited[br])dfsH(br,visited,t1*(-1),v1,v2);
        }
        return;
    }

    void dfs(int src,vector<int> *v1,vector<int> *v2)
    {
        bool *visited=new bool [N]{0};
        dfsH(src,visited,1,v1,v2);
        delete visited;
    }
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n,m;
    cin >> n >> m;

    Graf a(n+1);
    vector<int> v1,v2;

    for(int i=0; i<m; i++)
    {
        int x,y;
        cin >> x >> y;
        a.addEdge(x,y,true);
    }
    a.dfs(1,&v1,&v2);

    cout << v1.size() << " " << v2.size() << endl;
    for(auto i:v1)cout << i << " ";
    cout << endl;
    for(auto i:v2)cout << i << " ";
    cout << endl;

    return 0;
}