#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXN 1005
#define MAXM 2000005

typedef struct {
    int to, next;
} Edge;

Edge edges[2 * MAXM];
int head[MAXN], ecnt = 0;

int N, M;
int color[MAXN];   
int comp[MAXN];    
int q[MAXN];

void add_edge(int u, int v) {
    edges[ecnt].to = v;
    edges[ecnt].next = head[u];
    head[u] = ecnt++;
}

int main() {
    scanf("%d %d", &N, &M);

    memset(head, -1, sizeof(head));

    int A, B;
    for (int i = 0; i < M; i++) {
        scanf("%d %d", &A, &B);
        add_edge(A, B);
        add_edge(B, A);
    }

    memset(color, -1, sizeof(color));
    int total_cut = 0;


    for (int i = 1; i <= N; i++) {
        if (color[i] != -1) continue;

        int front = 0, back = 0;
        q[back++] = i;
        color[i] = 0;

        int cnt[2] = {1, 0};
        int edges_cut = 0;

        while (front < back) {
            int u = q[front++];
            for (int e = head[u]; e != -1; e = edges[e].next) {
                int v = edges[e].to;
                if (color[v] == -1) {
                    color[v] = color[u] ^ 1;
                    cnt[color[v]]++;
                    q[back++] = v;
                } else if (color[v] != color[u]) {
                    edges_cut++;
                }
            }
        }


        edges_cut /= 2;
        total_cut += edges_cut;
    }

    if (total_cut < M / 2) {
        printf("-1\n");
        return 0;
    }


    int team0[MAXN], team1[MAXN];
    int c0 = 0, c1 = 0;

    for (int i = 1; i <= N; i++) {
        if (color[i] == 0) team0[c0++] = i;
        else team1[c1++] = i;
    }

    printf("%d %d\n", c0, c1);
    for (int i = 0; i < c0; i++) printf("%d ", team0[i]);
    printf("\n");
    for (int i = 0; i < c1; i++) printf("%d ", team1[i]);
    printf("\n");

    return 0;
}