#include <stdio.h>
#include <stdlib.h>

#define MAXN 1005
#define MAXM 1000005

int N, M;
int A[MAXM], B[MAXM];
int team[MAXN];

int calc_cut() {
    int cut = 0;
    for (int i = 0; i < M; i++)
        if (team[A[i]] != team[B[i]])
            cut++;
    return cut;
}

int main() {
    scanf("%d %d", &N, &M);

    for (int i = 0; i < M; i++)
        scanf("%d %d", &A[i], &B[i]);


    for (int i = 1; i <= N; i++)
        team[i] = 0;

    int improved = 1;
    int cut = calc_cut();

    while (improved) {
        improved = 0;
        for (int i = 1; i <= N; i++) {
            team[i] ^= 1;             
            int new_cut = calc_cut();
            if (new_cut > cut) {
                cut = new_cut;
                improved = 1;
            } else {
                team[i] ^= 1;        
            }
        }
    }

    if (cut < M / 2) {
        printf("-1\n");
        return 0;
    }

    int t0[MAXN], t1[MAXN], c0 = 0, c1 = 0;
    for (int i = 1; i <= N; i++) {
        if (team[i] == 0) t0[c0++] = i;
        else t1[c1++] = i;
    }

    printf("%d %d\n", c0, c1);
    for (int i = 0; i < c0; i++) printf("%d ", t0[i]);
    printf("\n");
    for (int i = 0; i < c1; i++) printf("%d ", t1[i]);
    printf("\n");

    return 0;
}