#include <stdio.h>
#include <stdlib.h>

#define MAXN 1005
#define MAXM 1000005

int N, M;
int A[MAXM], B[MAXM];
int team[MAXN]; // 0 or 1
int adj[MAXN][2]; // temporary counters

int main() {
    scanf("%d %d", &N, &M);

    for (int i = 0; i < M; i++) {
        scanf("%d %d", &A[i], &B[i]);
    }

    // inicijalno svi nepostavljeni
    for (int i = 1; i <= N; i++) {
        team[i] = -1;
    }

    // greedy dodela
    for (int i = 0; i < M; i++) {
        int u = A[i], v = B[i];

        if (team[u] == -1 && team[v] == -1) {
            team[u] = 0;
            team[v] = 1;
        } else if (team[u] == -1) {
            team[u] = team[v] ^ 1;
        } else if (team[v] == -1) {
            team[v] = team[u] ^ 1;
        }
    }

    // svi koji su ostali – bilo gde
    for (int i = 1; i <= N; i++) {
        if (team[i] == -1)
            team[i] = 0;
    }

    // formiranje timova
    int P = 0, D = 0;
    for (int i = 1; i <= N; i++) {
        if (team[i] == 0) P++;
        else D++;
    }

    printf("%d %d\n", P, D);

    for (int i = 1; i <= N; i++)
        if (team[i] == 0)
            printf("%d ", i);
    printf("\n");

    for (int i = 1; i <= N; i++)
        if (team[i] == 1)
            printf("%d ", i);
    printf("\n");

    return 0;
}