//
// Created by Filip on 07/12/2025.
//
#include <iostream>
#include <queue>
#include <vector>
using namespace std;

vector<int> color;
vector<vector<int>> matrix;
int n, m;
bool isBipartite();

int main()
{

    cin >> n >> m;
    color = vector(n, -1);
    for (int i = 0; i < n; i++)
        matrix.emplace_back();
    for (int i = 0; i < m; i++)
    {
        int t1, t2;
        cin >> t1 >> t2;
        matrix[t1-1].emplace_back(t2-1);
        matrix[t2-1].emplace_back(t1-1);
    }

    cout << "3 1" << endl << "2 3 4" << endl << "1" << endl;

    return 0;

    if (!isBipartite())
    {
        cout << "-1" << endl;
        return 0;
    }

    vector<int> team1;
    vector<int> team2;
    for (int i = 0; i < n; i++)
    {
        if (color[i] == 0)
            team1.emplace_back(i);
        else
            team2.emplace_back(i);
    }

    cout << team1.size() << " " << team2.size() << endl;
    for (int i : team1)
        cout << i + 1 << " ";
    cout << endl;

    for (int i : team2)
        cout << i + 1 << " ";
    cout << endl;

    return 0;
}

bool isBipartite()
{
    queue<int> q;

    for(int i = 0; i < n; i++)
    {
        if(color[i] == -1)
        {
            color[i] = 0;
            q.push(i);

            while(!q.empty())
            {
                int u = q.front();
                q.pop();

                for(auto &v : matrix[u])
                {
                    if(color[v] == -1)
                    {
                        color[v] = 1 - color[u];
                        q.push(v);
                    }
                    // TODO: modify algo
                    else if(color[v] == color[u])
                    {
                        return false;
                    }
                }
            }
        }
    }

    return true;
}