//
// Created by Filip on 07/12/2025.
//
#include <iostream>
#include <queue>
#include <vector>
#include <algorithm>
#include <map>
#include <unordered_map>
using namespace std;

vector<int> color;
vector<bool> has_visited;
vector<bool> has_visited_local;
vector<bool> has_visited_edge;
//vector<vector<int>> odd_cycles_sorted;
vector<size_t> vec_hash;

// maps which edge breaks which cycles
map<int, vector<int>> edges_to_cycle;

vector<vector<pair<short, int>>> matrix;
int n, m;
bool isBipartite();
void SearchOddCycle();

std::size_t HASH_vec(std::vector<int> const& vec) {
    std::size_t seed = vec.size();
    for(auto x : vec) {
        x = ((x >> 16) ^ x) * 0x45d9f3b;
        x = ((x >> 16) ^ x) * 0x45d9f3b;
        x = (x >> 16) ^ x;
        seed ^= x + 0x9e3779b9 + (seed << 6) + (seed >> 2);
    }
    return seed;
}

vector<pair<int, int>> vert_ids;

int main()
{
    cin >> n >> m;
    color = vector(n, -1);
    has_visited = vector(n, false);
    has_visited_local = vector(n, false);
    has_visited_edge = vector(m, false);
    // edges_used_sorted = vector<vector<int>>(m, {{}});
    for (int i = 0; i < n; i++)
        matrix.emplace_back();
    int e_id = 0;
    for (int i = 0; i < m; i++)
    {
        int t1, t2;
        cin >> t1 >> t2;
        vert_ids.emplace_back(t1-1, t2-1);
        matrix[t1-1].emplace_back(t2-1, e_id);
        matrix[t2-1].emplace_back(t1-1, e_id);
        e_id++;
    }

    SearchOddCycle();

    vector<pair<int, vector<int>>> edges(edges_to_cycle.size());
    std::transform(edges_to_cycle.begin(), edges_to_cycle.end(), edges.begin(),[](const pair<const int, vector<int>>& a) -> pair<int, vector<int>>
    {
        return make_pair(a.first ,a.second);
    });

    sort(edges.begin(), edges.end(), [](const pair<int, vector<int>>& a, const pair<int, vector<int>>& b){return a.second.size() < b.second.size();} );
    for (auto edge : edges)
    {
        sort(edge.second.begin(), edge.second.end());
    }
    int old_m = m;

    bool not_p = false;

    vector<int> removed_edges;
    while (!edges.empty())
    {
        auto ve2 = edges.back();
        edges.pop_back();
        if (ve2.second.empty())
            continue;

        m--;
        removed_edges.push_back(ve2.first);
        if (m < old_m/2)
        {
            not_p = true;
            // break;
        }
        vector<int> t;
        for (auto & edge : edges)
        {
            t.clear();
            if (edge.second.empty())
                continue;

            set_difference(edge.second.begin(), edge.second.end(), ve2.second.begin(), ve2.second.end(), std::back_inserter(t));
            edge.second = t;
        }
        sort(edges.begin(), edges.end(), [](const pair<int, vector<int>>& a, const pair<int, vector<int>>& b){return a.second.size() < b.second.size();} );
    }

    //cout << not_p << endl;

    for (int removed_edge : removed_edges)
    {
        auto & [u ,v] = vert_ids[removed_edge];
        auto & mat_vec = matrix[u];

        int index1 = -1;
        for (int i = 0; i < mat_vec.size(); ++i)
        {
            if (mat_vec[i].second == removed_edge)
            {
                index1 = i;
                break;
            }
        }
        mat_vec.erase(std::next(mat_vec.begin(), index1));

        index1 = -1;
        auto & mat_vec2 = matrix[v];
        for (int i = 0; i < mat_vec2.size(); ++i)
        {
            if (mat_vec2[i].second == removed_edge)
            {
                index1 = i;
                break;
            }
        }

        mat_vec2.erase(std::next(mat_vec2.begin(), index1));
    }

    bool res = isBipartite();
    // __builtin_trap();;
    if (m < old_m/2)
    {
        cout << "-1" << endl;
        return 0;
    }

    vector<int> team1;
    vector<int> team2;
    for (int i = 0; i < n; i++)
    {
        if (color[i] == 0)
            team1.emplace_back(i);
        else
            team2.emplace_back(i);
    }

    cout << team1.size() << " " << team2.size() << endl;
    for (int i : team1)
        cout << i + 1 << " ";
    cout << endl;

    for (int i : team2)
        cout << i + 1 << " ";
    cout << endl;

    return 0;
}

bool isBipartite()
{
    queue<int> q;

    for(int i = 0; i < n; i++)
    {
        if(color[i] == -1)
        {
            color[i] = 0;
            q.push(i);

            while(!q.empty())
            {
                int u = q.front();
                q.pop();

                for(auto &[v, _] : matrix[u])
                {
                    if(color[v] == -1)
                    {
                        color[v] = 1 - color[u];
                        q.push(v);
                    }
                    else if(color[v] == color[u])
                    {
                        return false;
                    }
                }
            }
        }
    }

    return true;
}

int cycle_counter = 0;

void SearchForOddCycleDFS(int i, int e, vector<int>& s, vector<int>& v)
{
    //if (has_visited_edge[e])
        //return;
    if (has_visited_local[i])
    {
        if (s.size() > 1)
        {
            auto res = find(v.begin(), v.end(), i);
            int loop_len = std::distance(res, v.end());
            bool is_odd = loop_len % 2 == 1;
            if (is_odd)
            {
                vector<int> temp;

                temp.insert(temp.begin(),std::prev(s.end(), loop_len - 1), s.end());
                temp.push_back(e);

                //sort(temp.begin(), temp.end());
                auto hash = HASH_vec(temp);
                //auto pos1 = lower_bound(odd_cycles_sorted.begin(), odd_cycles_sorted.end(), temp, [](const vector<int>& va1, const vector<int>& va2) { return va1.size() > va2.size(); });
                //auto pos2 = upper_bound(odd_cycles_sorted.begin(), odd_cycles_sorted.end(), temp, [](const vector<int>& va1, const vector<int>& va2) { return va1.size() > va2.size(); });

               /* bool already_found = false;
                for (auto i = pos1; i != pos2; ++i)
                {
                    if (*i == temp)
                    {
                        already_found = true;
                        break;
                    }
                }*/
                auto pos1 = lower_bound(vec_hash.begin(), vec_hash.end(), hash);

                bool hash_match = false;
                if (pos1 != vec_hash.end())
                    hash_match = *pos1 == hash;

                if (!hash_match)
                {
                    vec_hash.insert(vec_hash.begin(), hash);
                    for (int temp1 : temp)
                    {
                        edges_to_cycle[temp1].push_back(cycle_counter);
                    }
                    cycle_counter++;
                }

            }
        }
        return;
    }
    int prev = -1;
    if (!v.empty())
        prev = v.back();
    has_visited_local[i] = true;
    has_visited[i] = true;
    // has_visited_edge[e] = true;
    s.push_back(e);
    v.push_back(i);
    for (auto& [i1, e1]  : matrix[i])
    {
        if (i1 != prev)
        {
            // cout << "V: " << i1 + 1 << endl;
            SearchForOddCycleDFS(i1, e1, s, v);
        }
    }
    s.pop_back();
    v.pop_back();
    has_visited_local[i] = false;
}

void SearchOddCycle()
{
    for (int i = 0; i < n; ++i)
    {
        if (has_visited[i])
            continue;
        has_visited[i] = true;
        has_visited_local = vector(n, false);
        has_visited_local[i] = true;
        for (auto & [v, e] : matrix[i])
        {
            vector<int> edges;
            vector<int> vi;
            // cout << "V: " << v + 1 << endl;
            vi.push_back(i);
            SearchForOddCycleDFS(v, e, edges, vi);
        }
    }
    // sort(edges_to_cycle.begin(), edges_to_cycle.end(), [](const pair<const int, vector<int>>& a, const pair<const int, vector<int>>& b){return a.second.size() < b.second.size();});
}