#include <iostream>
#include <vector>
#include <queue>

using namespace std;
void bfs_povezani(vector<vector<int>>& graf, int i, vector<bool>& poseta, vector<bool>& boje);
void bfs(vector<vector<int>>& graf, vector<bool>& boje);
void sortiraj(vector<vector<int>>& graf);
bool zameni(vector<int> a, vector<int> b);

int main()
{
    int n, m;
    cin>>n>>m;
    vector<bool> boje(n, false);
    vector<vector<int>> graf(n);

    for(int i=0; i<m; i++)
    {
        int x,y;
        cin>>x>>y;
        graf[x-1].push_back(y-1);
    }
    sortiraj(graf);

    for(auto i : graf)
    {
        for(int j : i)
        {
            cout<<j<<" ";
        }
        cout<<endl;
    }

    bfs(graf, boje);

    for(bool i : boje)
    {
        if(i)
            cout<<"Crvena  ";
        else
            cout<<"Crna ";
    }


    return 0;
}

void bfs_povezani(vector<vector<int>>& graf, int i, vector<bool>& poseta, vector<bool>& boje)
{
    queue<int> q;
    q.push(i);
    poseta[i] = true;

    while(!q.empty())
    {
        int tr = q.front();
        q.pop();
        for(int x : graf[tr])
        {
            if(!poseta[x])
            {
                poseta[x] = true;
                boje[x] = !boje[tr];
                q.push(x);
            }
        }
    }

}

void bfs(vector<vector<int>>& graf, vector<bool>& boje)
{
    int n = boje.size();
    vector<bool> poseta(n, false);

    for(int i=0; i<n; i++)
    {
        if(!poseta[i])
            bfs_povezani(graf, i, poseta, boje);
    }
}


void sortiraj(vector<vector<int>>& graf)
{
    for(auto& i : graf)
    {
        for(auto& j : graf)
        {
            if(zameni(i,j))
            {
                vector<int> pom = i;
                i = j;
                j = pom;
            }

        }
    }
}

bool zameni(vector<int> a, vector<int> b)
{
    if(a.size() < b.size() && a.size() > 0)
        return true;
    else
        return true;

}