import random

def solve():
    import sys
    input = sys.stdin.readline

    N, M = map(int, input().split())
    edges = []
    adj = [[] for _ in range(N+1)]
    for _ in range(M):
        a, b = map(int, input().split())
        edges.append((a, b))
        adj[a].append(b)
        adj[b].append(a)

 
    members = list(range(1, N+1))
    random.shuffle(members)
    team = [0]*(N+1)
    teamA = members[:N//2]
    teamB = members[N//2:]
    for v in teamB:
        team[v] = 1

    improved = True
    while improved:
        improved = False
        for v in range(1, N+1):
            same = sum(1 for u in adj[v] if team[u] == team[v])
            other = sum(1 for u in adj[v] if team[u] != team[v])
            if same > other:
                team[v] ^= 1
                improved = True

    teamA = [str(i) for i in range(1, N+1) if team[i] == 0]
    teamB = [str(i) for i in range(1, N+1) if team[i] == 1]

    satisfied = sum(1 for a, b in edges if team[a] != team[b])

    if satisfied < M//2:
        print(-1)
        return

    print(len(teamA), len(teamB))
    print(" ".join(teamA))
    print(" ".join(teamB))

if __name__ == "__main__":
    solve()