#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int N, M;
        cin >> N >> M;
        vector<long long> K(N);
        for (int i = 0; i < N; i++) cin >> K[i];

        vector<vector<int>> adj(N);
        vector<int> outdeg(N, 0);
        for (int i = 0; i < M; i++) {
            int u, v;
            cin >> u >> v;
            adj[u].push_back(v);
            outdeg[u]++;
        }

        vector<int> visited(N, 0), order;
        function<void(int)> dfs1 = [&](int u) {
            visited[u] = 1;
            for (int v : adj[u]) if (!visited[v]) dfs1(v);
            order.push_back(u);
        };
        for (int i = 0; i < N; i++) if (!visited[i]) dfs1(i);

        vector<vector<int>> radj(N);
        for (int u = 0; u < N; u++)
            for (int v : adj[u])
                radj[v].push_back(u);

        fill(visited.begin(), visited.end(), 0);
        vector<int> comp(N, -1);
        int cid = 0;
        function<void(int)> dfs2 = [&](int u) {
            visited[u] = 1;
            comp[u] = cid;
            for (int v : radj[u]) if (!visited[v]) dfs2(v);
        };

        for (int i = N-1; i >= 0; i--)
            if (!visited[order[i]]) { dfs2(order[i]); cid++; }

        vector<long long> sum(cid, 0);
        for (int i = 0; i < N; i++) sum[comp[i]] += K[i];

        vector<int> out(cid, 0);
        for (int u = 0; u < N; u++)
            for (int v : adj[u])
                if (comp[u] != comp[v]) out[comp[u]] = 1;

        long long ans = LLONG_MIN;
        for (int i = 0; i < cid; i++)
            if (!out[i] && sum[i] > 0) ans = max(ans, sum[i]);

        cout << (ans == LLONG_MIN ? -1 : ans) << "\n";
    }
}