#include <bits/stdc++.h>
using namespace std;

const int MAXN = 505;
int N, M;
int K[MAXN];
vector<int> G[MAXN];
vector<int> GT[MAXN];
bool visited[MAXN];
vector<int> order;
int comp[MAXN];

void dfs1(int v) {
    visited[v] = true;
    for(int u : G[v]) if(!visited[u]) dfs1(u);
    order.push_back(v);
}

void dfs2(int v, int c) {
    comp[v] = c;
    for(int u : GT[v]) if(comp[u] == -1) dfs2(u, c);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while(T--){
        cin >> N >> M;
        for(int i=0;i<N;i++) G[i].clear(), GT[i].clear();
        for(int i=0;i<N;i++) cin >> K[i];
        for(int i=0;i<M;i++){
            int a,b; cin >> a >> b;
            G[a].push_back(b);
            GT[b].push_back(a);
        }

        fill(visited, visited+N, false);
        order.clear();
        for(int i=0;i<N;i++) if(!visited[i]) dfs1(i);

        fill(comp, comp+N, -1);
        int cid = 0;
        for(int i=N-1;i>=0;i--){
            int v = order[i];
            if(comp[v] == -1) dfs2(v, cid++);
        }

        vector<long long> comp_sum(cid,0);
        vector<bool> is_sink(cid,true);

        for(int v=0;v<N;v++) comp_sum[comp[v]] += K[v];
        for(int v=0;v<N;v++){
            for(int u : G[v]){
                if(comp[u] != comp[v]) is_sink[comp[v]] = false;
            }
        }

        long long ans = -1e18;
        for(int i=0;i<cid;i++) if(is_sink[i]) ans = max(ans, comp_sum[i]);
        if(ans <= 0) cout << -1 << "\n";
        else cout << ans << "\n";
    }
}