#include <iostream>
#include <bits/stdc++.h>

using namespace std;

bool provera(vector<pair<int,int>> &zelje, vector<int> &tim, int m)
{
    int br = 0;
    
    for (int i=0; i<m; i++)
    {
        int prvi = zelje[i].first;
        int drugi = zelje[i].second;
        
        if (tim[prvi] != tim[drugi])
            br++;
    }
    
    if (br >= m/2)
        return true;
    else
        return false;
}

vector<int> bfs(vector<vector<int>> &graf, int n)
{
    queue<int> q;
    vector<int> tim(n+1, -1);
    
    for(int i=1; i<=n; i++)
    {
        if(tim[i] == -1)
        {
            q.push(i);
            tim[i] = 0;
            
            while(!q.empty())
            {
                int trenutni = q.front();
                q.pop();
                
                for(int sl : graf[trenutni])
                {
                    if(tim[sl] == -1)
                    {
                        q.push(sl);
                        tim[sl] = 1 - tim[trenutni];
                    }
                }
            }
        }
    }
    return tim;
}

int main()
{
    int n,m;
    cin>>n>>m;
    vector<pair<int,int>> zelje;
    vector<vector<int>> graf(n+1);
    for(int i=0; i<m; i++)
    {
        int a,b;
        cin>>a>>b;
        zelje.push_back({a,b});
        graf[a].push_back(b);
        graf[b].push_back(a);
    }
    
    vector<int> tim = bfs(graf, n);
    if(!provera(zelje, tim, m))
    {
        cout << "Nije moguce." << endl;
        return 0;
    }
    
    vector<int> prvi;
    vector<int> drugi;
    for(int i=1; i<=n; i++)
    {
        if(tim[i] == 0)
            prvi.push_back(i);
        else
            drugi.push_back(i);
    }
    cout << prvi.size() << " " << drugi.size() << endl;
    
    int a = prvi.size();
    int b = drugi.size();
    for(int i=0; i<a; i++)
        cout << prvi[i] << " ";

    cout << endl;
    for(int i=0; i<b; i++)
        cout << drugi[i] << " ";
    
    return 0;
}