T = int(input())

def dfs(graph, v, visited, order):
    visited[v] = True
    for u in graph[v]:
        if not visited[u]:
            dfs(graph, u, visited, order)
    order.append(v)

def dfs_rev(graph_rev, v, visited, component):
    visited[v] = True
    component.append(v)
    for u in graph_rev[v]:
        if not visited[u]:
            dfs_rev(graph_rev, u, visited, component)

for _ in range(T):
    N, M = map(int, input().split())
    K = list(map(int, input().split()))

    graph = [[] for _ in range(N)]
    graph_rev = [[] for _ in range(N)]
    for _ in range(M):
        A, B = map(int, input().split())
        A -= 1
        B -= 1
        graph[A].append(B)
        graph_rev[B].append(A)

    visited = [False]*N
    order = []
    for i in range(N):
        if not visited[i]:
            dfs(graph, i, visited, order)

    visited = [False]*N
    scc_list = []
    for v in reversed(order):
        if not visited[v]:
            component = []
            dfs_rev(graph_rev, v, visited, component)
            scc_list.append(component)

    max_quality = -1
    for comp in scc_list:
        has_out = False
        comp_set = set(comp)
        quality = 0
        for node in comp:
            quality += K[node]
            for nei in graph[node]:
                if nei not in comp_set:
                    has_out = True
        if not has_out and quality > 0:
            max_quality = max(max_quality, quality)

    print(max_quality)