#include <bits/stdc++.h>
using namespace std;

const int MAXN = 500000;

vector<int> g[MAXN], gr[MAXN];
bool used[MAXN];
int comp[MAXN];
long long K[MAXN];
long long compSum[MAXN];
bool hasOut[MAXN];

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--) {
        int N, M;
        cin >> N >> M;

        for (int i = 0; i < N; i++) {
            cin >> K[i];
            g[i].clear();
            gr[i].clear();
            used[i] = false;
        }

        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            g[a].push_back(b);
            gr[b].push_back(a);
        }

        vector<int> order;
        function<void(int)> dfs1 = [&](int v) {
            used[v] = true;
            for (int u : g[v])
                if (!used[u])
                    dfs1(u);
            order.push_back(v);
        };

        for (int i = 0; i < N; i++)
            if (!used[i])
                dfs1(i);

        memset(comp, -1, sizeof(int) * N);
        int cid = 0;

        function<void(int)> dfs2 = [&](int v) {
            comp[v] = cid;
            compSum[cid] += K[v];
            for (int u : gr[v])
                if (comp[u] == -1)
                    dfs2(u);
        };

        for (int i = N - 1; i >= 0; i--) {
            int v = order[i];
            if (comp[v] == -1) {
                compSum[cid] = 0;
                dfs2(v);
                cid++;
            }
        }

        for (int i = 0; i < cid; i++)
            hasOut[i] = false;

        for (int v = 0; v < N; v++) {
            for (int u : g[v]) {
                if (comp[v] != comp[u])
                    hasOut[comp[v]] = true;
            }
        }

        long long ans = -1;
        for (int i = 0; i < cid; i++) {
            if (!hasOut[i] && compSum[i] > 0) {
                ans = max(ans, compSum[i]);
            }
        }

        cout << ans << "\n";
    }

    return 0;
}