#include <stdio.h>
#include <stdlib.h>

#define MAXN 500
#define MAXM 1000000

int N, M;
int K[MAXN];

int head[MAXN], to[MAXM], nxt[MAXM];
int edge_cnt;

int dfn[MAXN], low[MAXN], onStack[MAXN];
int stack[MAXN], top;
int scc_id[MAXN], scc_cnt;
int timer;

long long scc_sum[MAXN];
int scc_out[MAXN];

void add_edge(int u, int v) {
    to[edge_cnt] = v;
    nxt[edge_cnt] = head[u];
    head[u] = edge_cnt++;
}

int min(int a, int b) {
    return a < b ? a : b;
}

void tarjan(int u) {
    dfn[u] = low[u] = ++timer;
    stack[++top] = u;
    onStack[u] = 1;

    for (int e = head[u]; e != -1; e = nxt[e]) {
        int v = to[e];
        if (!dfn[v]) {
            tarjan(v);
            low[u] = min(low[u], low[v]);
        } else if (onStack[v]) {
            low[u] = min(low[u], dfn[v]);
        }
    }

    if (dfn[u] == low[u]) {
        int v;
        do {
            v = stack[top--];
            onStack[v] = 0;
            scc_id[v] = scc_cnt;
            scc_sum[scc_cnt] += K[v];
        } while (v != u);
        scc_cnt++;
    }
}

int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &N, &M);

        for (int i = 0; i < N; i++) {
            scanf("%d", &K[i]);
            head[i] = -1;
            dfn[i] = low[i] = onStack[i] = 0;
        }

        edge_cnt = 0;
        timer = 0;
        scc_cnt = 0;
        top = 0;

        for (int i = 0; i < M; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge(a, b);
        }

        for (int i = 0; i < N; i++) {
            if (!dfn[i])
                tarjan(i);
        }

        for (int i = 0; i < scc_cnt; i++)
            scc_out[i] = 0;

        for (int u = 0; u < N; u++) {
            for (int e = head[u]; e != -1; e = nxt[e]) {
                int v = to[e];
                if (scc_id[u] != scc_id[v]) {
                    scc_out[scc_id[u]] = 1;
                }
            }
        }

        long long ans = -1;
        for (int i = 0; i < scc_cnt; i++) {
            if (!scc_out[i] && scc_sum[i] > 0) {
                if (scc_sum[i] > ans)
                    ans = scc_sum[i];
            }
        }

        printf("%lld\n", ans);
    }

    return 0;
}