#include <bits/stdc++.h>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int n, m;
    cin >> n >> m;
    
    vector<pair<int,int>> grane(m);
    vector<vector<int>> g(n + 1);
    
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        grane[i] = {a, b};
        g[a].push_back(b);
        g[b].push_back(a);
    }
    
    int cilj = m / 2;
    
    vector<int> boja(n + 1, -1);
    int ispunjeno = 0;
    
    for (int start = 1; start <= n; start++) {
        if (boja[start] != -1) continue;
        
        queue<int> q;
        q.push(start);
        boja[start] = 0;
        bool bipartitan = true;
        
        while (!q.empty() && bipartitan) {
            int u = q.front();
            q.pop();
            
            for (int v : g[u]) {
                if (boja[v] == -1) {
                    boja[v] = 1 - boja[u];
                    q.push(v);
                } else if (boja[v] == boja[u]) {
                    bipartitan = false;
                    break;
                }
            }
        }
        
        if (!bipartitan) {
            queue<int> q2;
            q2.push(start);
            boja[start] = -1;
            
            while (!q2.empty()) {
                int u = q2.front();
                q2.pop();
                
                for (int v : g[u]) {
                    if (boja[v] != -1) {
                        boja[v] = -1;
                        q2.push(v);
                    }
                }
            }
        }
    }
    
    for (auto [a, b] : grane) {
        if (boja[a] != -1 && boja[b] != -1 && boja[a] != boja[b]) {
            ispunjeno++;
        }
    }
    
    if (ispunjeno < cilj) {
        mt19937 rng(42);
        for (int pokusaj = 0; pokusaj < 1000; pokusaj++) {
            fill(boja.begin(), boja.end(), -1);
            
            for (int i = 1; i <= n; i++) {
                boja[i] = rng() % 2;
            }
            
            int br = 0;
            for (auto [a, b] : grane) {
                if (boja[a] != boja[b]) br++;
            }
            
            if (br >= cilj) {
                ispunjeno = br;
                break;
            }
        }
    }
    
    for (auto [a, b] : grane) {
        if (boja[a] != -1 && boja[b] != -1 && boja[a] != boja[b]) {
            ispunjeno++;
        }
    }
    
    if (ispunjeno < cilj) {
        cout << -1 << '\n';
        return 0;
    }
    
    vector<int> tim1, tim2;
    for (int i = 1; i <= n; i++) {
        if (boja[i] == 0) tim1.push_back(i);
        else tim2.push_back(i);
    }
    
    cout << tim1.size() << ' ' << tim2.size() << '\n';
    for (int x : tim1) cout << x << ' ';
    cout << '\n';
    for (int x : tim2) cout << x << ' ';
    cout << '\n';
    
    return 0;
}