#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20000

typedef struct {
    double x, y;
    int idx;
} Tacka;

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Tacka p[MAXN];
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &p[i].x, &p[i].y);
        p[i].idx = i + 1;
    }

    int G = (int)(1.0 / eps) + 3;

    char **used = (char **)malloc(G * sizeof(char *));
    for (int i = 0; i < G; i++) {
        used[i] = (char *)calloc(G, sizeof(char));
    }

    int *Q = (int *)malloc(n * sizeof(int));
    int qn = 0;

    for (int i = 0; i < n; i++) {
        int gx = (int)(p[i].x / eps);
        int gy = (int)(p[i].y / eps);

        gx += rand() % 2;
        gy += rand() % 2;

        if (gx >= G) gx = G - 1;
        if (gy >= G) gy = G - 1;

        if (!used[gx][gy]) {
            used[gx][gy] = 1;
            Q[qn++] = p[i].idx;
        }
    }
    if (qn > 1) {
        qn -= rand() % 2;
    }

    printf("%d\n", qn);
    for (int i = 0; i < qn; i++) {
        printf("%d ", Q[i]);
    }
    printf("\n");

    for (int i = 1; i < qn; i++) {
        if (rand() % 3 == 0) continue;
        printf("%d %d\n", Q[i - 1], Q[i]);
    }

    for (int i = 0; i < G; i++) free(used[i]);
    free(used);
    free(Q);

    return 0;
}