#include <stdio.h>
#include <vector>
#include <queue>
#include <algorithm>

using namespace std;

struct Edge {
    int to, rev;
    long long cap;
    Edge(int _to, int _rev, long long _cap) : to(_to), rev(_rev), cap(_cap) {}
};

struct Dinic {
    int N;
    vector<vector<Edge>> G;
    vector<int> level, it;

    Dinic(int n) : N(n), G(n), level(n), it(n) {}

    void addEdge(int u, int v, long long c) {
        Edge a(v, (int)G[v].size(), c);
        Edge b(u, (int)G[u].size(), 0);
        G[u].push_back(a);
        G[v].push_back(b);
    }

    bool bfs(int s, int t) {
        fill(level.begin(), level.end(), -1);
        queue<int> q;
        level[s] = 0;
        q.push(s);
        while (!q.empty()) {
            int u = q.front(); q.pop();
            for (auto &e : G[u]) {
                if (e.cap > 0 && level[e.to] < 0) {
                    level[e.to] = level[u] + 1;
                    q.push(e.to);
                }
            }
        }
        return level[t] >= 0;
    }

    long long dfs(int u, int t, long long f) {
        if (u == t) return f;
        for (int &i = it[u]; i < (int)G[u].size(); i++) {
            Edge &e = G[u][i];
            if (e.cap > 0 && level[e.to] == level[u] + 1) {
                long long ret = dfs(e.to, t, min(f, e.cap));
                if (ret > 0) {
                    e.cap -= ret;
                    G[e.to][e.rev].cap += ret;
                    return ret;
                }
            }
        }
        return 0;
    }

    long long maxflow(int s, int t) {
        long long flow = 0;
        while (bfs(s, t)) {
            fill(it.begin(), it.end(), 0);
            while (true) {
                long long pushed = dfs(s, t, (long long)4e18);
                if (pushed == 0) break;
                flow += pushed;
            }
        }
        return flow;
    }
};

int main() {
    int T;
    if (scanf("%d", &T) != 1) return 0;
    const long long INF = (long long)4e18;

    while (T--) {
        int N, M;
        scanf("%d %d", &N, &M);
        vector<long long> K(N);
        for (int i = 0; i < N; i++) scanf("%lld", &K[i]);

        int S = N, Tt = N + 1;
        Dinic din(N + 2);

        long long posSum = 0;
        for (int i = 0; i < N; i++) {
            if (K[i] > 0) {
                posSum += K[i];
                din.addEdge(S, i, K[i]);
            } else if (K[i] < 0) {
                din.addEdge(i, Tt, -K[i]);
            }
        }

        for (int i = 0; i < M; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            din.addEdge(a, b, INF);
        }

        long long mincut = din.maxflow(S, Tt);
        long long best = posSum - mincut;
        if (best <= 0) printf("-1\n");
        else printf("%lld\n", best);
    }
    return 0;
}