using System;
using System.Collections.Generic;

class Program
{
    static List<int>[] g;
    static int[] color;
    static bool[] used;
    static List<int> comp;

    static void DFS(int u)
    {
        used[u] = true;
        comp.Add(u);
        foreach (int v in g[u])
        {
            if (!used[v])
            {
                color[v] = color[u] ^ 1;
                DFS(v);
            }
        }
    }

    static void Main()
    {
        var first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        int M = int.Parse(first[1]);

        g = new List<int>[N + 1];
        for (int i = 1; i <= N; i++) g[i] = new List<int>();

        var edges = new List<(int, int)>();

        for (int i = 0; i < M; i++)
        {
            var p = Console.ReadLine().Split();
            int a = int.Parse(p[0]);
            int b = int.Parse(p[1]);
            g[a].Add(b);
            g[b].Add(a);
            edges.Add((a, b));
        }

        color = new int[N + 1];
        used = new bool[N + 1];

        var team = new int[N + 1]; // ??????? ????

        foreach (var _ in new int[N]) { } // ???? ?? ???? ????????? ??

        for (int i = 1; i <= N; i++)
        {
            if (used[i]) continue;

            comp = new List<int>();
            color[i] = 0;
            DFS(i);

            int ok1 = 0, ok2 = 0;

            foreach (var (a, b) in edges)
            {
                if (comp.Contains(a) && comp.Contains(b))
                {
                    if (color[a] != color[b]) ok1++;
                    if (color[a] == color[b]) ok2++;
                }
            }

            bool flip = ok2 > ok1;
            foreach (int v in comp)
                team[v] = flip ? color[v] ^ 1 : color[v];
        }

        var A = new List<int>();
        var B = new List<int>();

        for (int i = 1; i <= N; i++)
        {
            if (team[i] == 0) A.Add(i);
            else B.Add(i);
        }

        Console.WriteLine($"{A.Count} {B.Count}");
        Console.WriteLine(string.Join(" ", A));
        Console.WriteLine(string.Join(" ", B));
    }
}